/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.solr;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.IndexWriterParams;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.indexwriter.solr.SolrUtils;
import org.apache.nutch.util.StringUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
implements IndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<SolrClient> solrClients;
    private ModifiableSolrParams params;
    private Configuration config;
    private final List<SolrInputDocument> inputDocs = new ArrayList<SolrInputDocument>();
    private final List<String> deleteIds = new ArrayList<String>();
    private String type;
    private String[] urls;
    private String collection;
    private int batchSize;
    private int numDeletes = 0;
    private int totalAdds = 0;
    private int totalDeletes = 0;
    private boolean delete = false;
    private String weightField;
    private boolean auth;
    private String username;
    private String password;
    private String authHeaderName;
    private String authHeaderValue;

    public void open(Configuration conf, String name) {
    }

    public void open(IndexWriterParams parameters) {
        this.type = parameters.get("type", "http");
        this.urls = parameters.getStrings("url");
        this.collection = (String)parameters.get((Object)"collection");
        if (this.urls == null) {
            String message = "Missing SOLR URL.\n" + String.valueOf(this.describe());
            LOG.error(message);
            throw new RuntimeException(message);
        }
        this.auth = parameters.getBoolean("auth", false);
        this.username = (String)parameters.get((Object)"username");
        this.password = (String)parameters.get((Object)"password");
        this.authHeaderName = parameters.get("auth.header.name", "");
        this.authHeaderValue = parameters.get("auth.header.value", "");
        this.solrClients = new ArrayList<SolrClient>();
        switch (this.type) {
            case "http": {
                for (String url : this.urls) {
                    if (this.auth && !StringUtil.isEmpty((String)this.authHeaderName) && !StringUtil.isEmpty((String)this.authHeaderValue)) {
                        this.solrClients.add(SolrUtils.getHttpSolrClientHeaderAuthorization(url, this.authHeaderName, this.authHeaderValue));
                        continue;
                    }
                    if (this.auth && !StringUtil.isEmpty((String)this.username) && !StringUtil.isEmpty((String)this.password)) {
                        this.solrClients.add(SolrUtils.getHttpSolrClient(url, this.username, this.password));
                        continue;
                    }
                    this.solrClients.add(SolrUtils.getHttpSolrClient(url));
                }
                break;
            }
            case "cloud": {
                CloudSolrClient sc = this.auth && !StringUtil.isEmpty((String)this.authHeaderName) && !StringUtil.isEmpty((String)this.authHeaderValue) ? SolrUtils.getCloudSolrClientHeaderAuthorization(Arrays.asList(this.urls), this.authHeaderName, this.authHeaderValue) : (this.auth && !StringUtil.isEmpty((String)this.username) && !StringUtil.isEmpty((String)this.password) ? SolrUtils.getCloudSolrClient(Arrays.asList(this.urls), this.username, this.password) : SolrUtils.getCloudSolrClient(Arrays.asList(this.urls)));
                sc.setDefaultCollection(this.collection);
                this.solrClients.add((SolrClient)sc);
                break;
            }
            case "concurrent": {
                throw new UnsupportedOperationException("The type \"concurrent\" is not yet supported.");
            }
            case "lb": {
                throw new UnsupportedOperationException("The type \"lb\" is not yet supported.");
            }
            default: {
                throw new IllegalArgumentException("The type \"" + this.type + "\" is not supported.");
            }
        }
        this.init(parameters);
    }

    private void init(IndexWriterParams properties) {
        this.batchSize = properties.getInt("commitSize", 1000);
        this.delete = this.config.getBoolean("indexer.delete", false);
        this.weightField = properties.get("weight.field", "");
        this.params = new ModifiableSolrParams();
        String paramString = this.config.get("indexer.additional.params");
        if (paramString != null) {
            String[] values;
            for (String v : values = paramString.split("&")) {
                String[] kv = v.split("=");
                if (kv.length < 2) continue;
                this.params.add(kv[0], new String[]{kv[1]});
            }
        }
    }

    public void delete(String key) throws IOException {
        key = key.replaceAll("!", "\\!");
        if (this.delete) {
            this.deleteIds.add(key);
            ++this.totalDeletes;
        }
        if (this.deleteIds.size() >= this.batchSize) {
            this.push();
        }
    }

    public void update(NutchDocument doc) throws IOException {
        this.write(doc);
    }

    public void write(NutchDocument doc) throws IOException {
        SolrInputDocument inputDoc = new SolrInputDocument(new String[0]);
        for (Map.Entry e : doc) {
            Iterator iterator = ((NutchField)e.getValue()).getValues().iterator();
            while (iterator.hasNext()) {
                Object val;
                Object val2 = val = iterator.next();
                if (val instanceof Date) {
                    val2 = DateTimeFormatter.ISO_INSTANT.format(((Date)val).toInstant());
                }
                if (((String)e.getKey()).equals("content") || ((String)e.getKey()).equals("title")) {
                    val2 = SolrUtils.stripNonCharCodepoints((String)val);
                }
                inputDoc.addField((String)e.getKey(), val2);
            }
        }
        if (!this.weightField.isEmpty()) {
            inputDoc.addField(this.weightField, (Object)Float.valueOf(doc.getWeight()));
        }
        this.inputDocs.add(inputDoc);
        ++this.totalAdds;
        if (this.inputDocs.size() + this.numDeletes >= this.batchSize) {
            this.push();
        }
    }

    public void close() throws IOException {
        this.commit();
        for (SolrClient solrClient : this.solrClients) {
            solrClient.close();
        }
    }

    public void commit() throws IOException {
        this.push();
        try {
            for (SolrClient solrClient : this.solrClients) {
                if (this.auth && !StringUtil.isEmpty((String)this.username) && !StringUtil.isEmpty((String)this.password)) {
                    UpdateRequest req = new UpdateRequest();
                    req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                    req.setBasicAuthCredentials(this.username, this.password);
                    solrClient.request((SolrRequest)req);
                    continue;
                }
                solrClient.commit();
            }
        }
        catch (SolrServerException e) {
            LOG.error("Failed to commit solr connection: {}", (Object)e.getMessage());
        }
    }

    private void push() throws IOException {
        UpdateRequest req;
        if (this.inputDocs.size() > 0) {
            try {
                LOG.info("Indexing {}/{} documents", (Object)this.inputDocs.size(), (Object)this.totalAdds);
                LOG.info("Deleting {} documents", (Object)this.numDeletes);
                this.numDeletes = 0;
                req = new UpdateRequest();
                req.add(this.inputDocs);
                req.setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, false, false);
                req.setParams(this.params);
                if (this.auth && !StringUtil.isEmpty((String)this.username) && !StringUtil.isEmpty((String)this.password)) {
                    req.setBasicAuthCredentials(this.username, this.password);
                }
                for (SolrClient solrClient : this.solrClients) {
                    solrClient.request((SolrRequest)req);
                }
            }
            catch (SolrServerException e) {
                throw SolrIndexWriter.makeIOException(e);
            }
            this.inputDocs.clear();
        }
        if (this.deleteIds.size() > 0) {
            try {
                LOG.info("SolrIndexer: deleting {}/{} documents", (Object)this.deleteIds.size(), (Object)this.totalDeletes);
                req = new UpdateRequest();
                req.deleteById(this.deleteIds);
                req.setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, false, false);
                req.setParams(this.params);
                if (this.auth && !StringUtil.isEmpty((String)this.username) && !StringUtil.isEmpty((String)this.password)) {
                    req.setBasicAuthCredentials(this.username, this.password);
                }
                for (SolrClient solrClient : this.solrClients) {
                    solrClient.request((SolrRequest)req);
                }
            }
            catch (SolrServerException e) {
                LOG.error("Error deleting: {}", this.deleteIds);
                throw SolrIndexWriter.makeIOException(e);
            }
            this.deleteIds.clear();
        }
    }

    private static IOException makeIOException(SolrServerException e) {
        return new IOException(e);
    }

    public Configuration getConf() {
        return this.config;
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Map<String, Map.Entry<String, Object>> describe() {
        LinkedHashMap<String, Map.Entry<String, Object>> properties = new LinkedHashMap<String, Map.Entry<String, Object>>();
        properties.put("type", new AbstractMap.SimpleEntry<String, String>("Specifies the SolrClient implementation to use. This is a string value of one of the following \"cloud\" or \"http\". The values represent CloudSolrServer or HttpSolrServer respectively.", this.type));
        properties.put("url", new AbstractMap.SimpleEntry<String, String>("Defines the fully qualified URL of Solr into which data should be indexed. Multiple URL can be provided using comma as a delimiter. When the value of type property is cloud, the URL should not include any collections or cores; just the root Solr path.", this.urls == null ? "" : String.join((CharSequence)",", this.urls)));
        properties.put("collection", new AbstractMap.SimpleEntry<String, String>("The collection used in requests. Only used when the value of type property is cloud.", this.collection));
        properties.put("commitSize", new AbstractMap.SimpleEntry<String, Integer>("Defines the number of documents to send to Solr in a single update batch. Decrease when handling very large documents to prevent Nutch from running out of memory.\nNote: It does not explicitly trigger a server side commit.", this.batchSize));
        properties.put("weight.field", new AbstractMap.SimpleEntry<String, String>("Field's name where the weight of the documents will be written. If it is empty no field will be used.", this.weightField));
        properties.put("auth", new AbstractMap.SimpleEntry<String, Boolean>("Whether to enable HTTP basic authentication for communicating with Solr. Use the username and password properties to configure your credentials.", this.auth));
        properties.put("auth.header.name", new AbstractMap.SimpleEntry<String, String>("The authentication header content name.", this.authHeaderName));
        properties.put("auth.header.value", new AbstractMap.SimpleEntry<String, String>("The authentication header content value.", StringUtil.mask((String)this.authHeaderValue)));
        properties.put("username", new AbstractMap.SimpleEntry<String, String>("The username of Solr server.", this.username));
        properties.put("password", new AbstractMap.SimpleEntry<String, String>("The password of Solr server.", StringUtil.mask((String)this.password)));
        return properties;
    }
}

