/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class BufferingBatchConsumer<T>
implements Consumer<List<T>> {
    private final Consumer<List<T>> delegateConsumer;
    private final int minBatchSize;
    private List<T> bufferedBatch;

    BufferingBatchConsumer(Consumer<List<T>> delegateConsumer, int minBatchSize) {
        this.delegateConsumer = delegateConsumer;
        this.minBatchSize = minBatchSize;
        this.bufferedBatch = new ArrayList<T>(minBatchSize);
    }

    @Override
    public void accept(List<T> batch) {
        this.bufferedBatch.addAll(batch);
        if (this.bufferedBatch.size() >= this.minBatchSize) {
            this.flush();
        }
    }

    public void flush() {
        if (!this.bufferedBatch.isEmpty()) {
            this.delegateConsumer.accept(this.bufferedBatch);
            this.bufferedBatch = new ArrayList<T>(this.minBatchSize);
        }
    }
}

