/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.breaker;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.breaker.CircuitBreaker;
import org.opensearch.common.breaker.CircuitBreakingException;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.indices.breaker.BreakerSettings;
import org.opensearch.indices.breaker.HierarchyCircuitBreakerService;

public class ChildMemoryCircuitBreaker
implements CircuitBreaker {
    private volatile LimitAndOverhead limitAndOverhead;
    private final CircuitBreaker.Durability durability;
    private final AtomicLong used;
    private final AtomicLong trippedCount;
    private final Logger logger;
    private final HierarchyCircuitBreakerService parent;
    private final String name;

    public ChildMemoryCircuitBreaker(BreakerSettings settings, Logger logger, HierarchyCircuitBreakerService parent, String name) {
        this.name = name;
        this.limitAndOverhead = new LimitAndOverhead(settings.getLimit(), settings.getOverhead());
        this.durability = settings.getDurability();
        this.used = new AtomicLong(0L);
        this.trippedCount = new AtomicLong(0L);
        this.logger = logger;
        logger.trace(() -> new ParameterizedMessage("creating ChildCircuitBreaker with settings {}", (Object)settings));
        this.parent = parent;
    }

    @Override
    public void circuitBreak(String fieldName, long bytesNeeded) {
        long memoryBytesLimit = this.limitAndOverhead.limit;
        this.trippedCount.incrementAndGet();
        String message = "[" + this.name + "] Data too large, data for [" + fieldName + "] would be [" + bytesNeeded + "/" + new ByteSizeValue(bytesNeeded) + "], which is larger than the limit of [" + memoryBytesLimit + "/" + new ByteSizeValue(memoryBytesLimit) + "]";
        this.logger.debug(() -> new ParameterizedMessage("{}", (Object)message));
        throw new CircuitBreakingException(message, bytesNeeded, memoryBytesLimit, this.durability);
    }

    @Override
    public double addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        LimitAndOverhead limitAndOverhead = this.limitAndOverhead;
        long memoryBytesLimit = limitAndOverhead.limit;
        double overheadConstant = limitAndOverhead.overhead;
        if (memoryBytesLimit == 0L) {
            this.circuitBreak(label, bytes);
        }
        long newUsed = memoryBytesLimit == -1L ? this.noLimit(bytes, label) : this.limit(bytes, label, overheadConstant, memoryBytesLimit);
        try {
            this.parent.checkParentLimit((long)((double)bytes * overheadConstant), label);
        }
        catch (CircuitBreakingException e) {
            this.addWithoutBreaking(-bytes);
            throw e;
        }
        assert (newUsed >= 0L) : "Used bytes: [" + newUsed + "] must be >= 0";
        return newUsed;
    }

    private long noLimit(long bytes, String label) {
        long newUsed = this.used.addAndGet(bytes);
        this.logger.trace(() -> new ParameterizedMessage("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: [-1b]]", new Object[]{this.name, new ByteSizeValue(bytes), label, new ByteSizeValue(newUsed)}));
        return newUsed;
    }

    private long limit(long bytes, String label, double overheadConstant, long memoryBytesLimit) {
        long newUsed;
        long currentUsed;
        do {
            currentUsed = this.used.get();
            newUsed = currentUsed + bytes;
            long newUsedWithOverhead = (long)((double)newUsed * overheadConstant);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: {} [{}], estimate: {} [{}]]", (Object)this.name, (Object)new ByteSizeValue(bytes), (Object)label, (Object)new ByteSizeValue(newUsed), (Object)memoryBytesLimit, (Object)new ByteSizeValue(memoryBytesLimit), (Object)newUsedWithOverhead, (Object)new ByteSizeValue(newUsedWithOverhead));
            }
            if (memoryBytesLimit <= 0L || newUsedWithOverhead <= memoryBytesLimit) continue;
            this.logger.warn("[{}] New used memory {} [{}] for data of [{}] would be larger than configured breaker: {} [{}], breaking", (Object)this.name, (Object)newUsedWithOverhead, (Object)new ByteSizeValue(newUsedWithOverhead), (Object)label, (Object)memoryBytesLimit, (Object)new ByteSizeValue(memoryBytesLimit));
            this.circuitBreak(label, newUsedWithOverhead);
        } while (!this.used.compareAndSet(currentUsed, newUsed));
        return newUsed;
    }

    @Override
    public long addWithoutBreaking(long bytes) {
        long u = this.used.addAndGet(bytes);
        this.logger.trace(() -> new ParameterizedMessage("[{}] Adjusted breaker by [{}] bytes, now [{}]", new Object[]{this.name, bytes, u}));
        assert (u >= 0L) : "Used bytes: [" + u + "] must be >= 0";
        return u;
    }

    @Override
    public long getUsed() {
        return this.used.get();
    }

    @Override
    public long getLimit() {
        return this.limitAndOverhead.limit;
    }

    @Override
    public double getOverhead() {
        return this.limitAndOverhead.overhead;
    }

    @Override
    public long getTrippedCount() {
        return this.trippedCount.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }

    @Override
    public void setLimitAndOverhead(long limit, double overhead) {
        this.limitAndOverhead = new LimitAndOverhead(limit, overhead);
    }

    private static class LimitAndOverhead {
        private final long limit;
        private final double overhead;

        LimitAndOverhead(long limit, double overhead) {
            this.limit = limit;
            this.overhead = overhead;
        }
    }
}

