/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.LegacyESVersion;
import org.opensearch.action.fieldcaps.FieldCapabilities;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class IndexFieldCapabilities
implements Writeable {
    private final String name;
    private final String type;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final Map<String, String> meta;

    IndexFieldCapabilities(String name, String type, boolean isSearchable, boolean isAggregatable, Map<String, String> meta) {
        this.name = name;
        this.type = type;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.meta = meta;
    }

    IndexFieldCapabilities(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_7_0)) {
            this.name = in.readString();
            this.type = in.readString();
            this.isSearchable = in.readBoolean();
            this.isAggregatable = in.readBoolean();
            this.meta = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            FieldCapabilities fieldCaps = new FieldCapabilities(in);
            this.name = fieldCaps.getName();
            this.type = fieldCaps.getType();
            this.isSearchable = fieldCaps.isSearchable();
            this.isAggregatable = fieldCaps.isAggregatable();
            this.meta = fieldCaps.meta().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((Set)entry.getValue()).iterator().next()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_7_0)) {
            out.writeString(this.name);
            out.writeString(this.type);
            out.writeBoolean(this.isSearchable);
            out.writeBoolean(this.isAggregatable);
            out.writeMap(this.meta, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            Map<String, Set<String>> wrappedMeta = this.meta.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singleton((String)entry.getValue())));
            FieldCapabilities fieldCaps = new FieldCapabilities(this.name, this.type, this.isSearchable, this.isAggregatable, null, null, null, wrappedMeta);
            fieldCaps.writeTo(out);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFieldCapabilities that = (IndexFieldCapabilities)o;
        return this.isSearchable == that.isSearchable && this.isAggregatable == that.isAggregatable && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.isSearchable, this.isAggregatable, this.meta);
    }
}

