/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.BindMethodAttribute;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

public final class ConfigurationPropertiesBean {
    private static final BindMethod JAVA_BEAN_BIND_METHOD = BindMethod.JAVA_BEAN;
    private static final BindMethod VALUE_OBJECT_BIND_METHOD = BindMethod.VALUE_OBJECT;
    private final String name;
    private final @Nullable Object instance;
    private final Bindable<?> bindTarget;

    private ConfigurationPropertiesBean(String name, @Nullable Object instance, Bindable<?> bindTarget) {
        this.name = name;
        this.instance = instance;
        this.bindTarget = bindTarget;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Object getInstance() {
        return this.instance;
    }

    Class<?> getType() {
        Class resolved = this.bindTarget.getType().resolve();
        Assert.state((resolved != null ? 1 : 0) != 0, (String)"'resolved' must not be null");
        return resolved;
    }

    public ConfigurationProperties getAnnotation() {
        ConfigurationProperties annotation = this.bindTarget.getAnnotation(ConfigurationProperties.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"'annotation' must not be null");
        return annotation;
    }

    public Bindable<?> asBindTarget() {
        return this.bindTarget;
    }

    public static Map<String, ConfigurationPropertiesBean> getAll(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            return ConfigurationPropertiesBean.getAll(configurableContext);
        }
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        applicationContext.getBeansWithAnnotation(ConfigurationProperties.class).forEach((name, instance) -> {
            ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get(applicationContext, instance, name);
            if (propertiesBean != null) {
                propertiesBeans.put((String)name, propertiesBean);
            }
        });
        return propertiesBeans;
    }

    private static Map<String, ConfigurationPropertiesBean> getAll(ConfigurableApplicationContext applicationContext) {
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Iterator beanNames = beanFactory.getBeanNamesIterator();
        while (beanNames.hasNext()) {
            String beanName = (String)beanNames.next();
            if (!ConfigurationPropertiesBean.isConfigurationPropertiesBean(beanFactory, beanName)) continue;
            try {
                Object bean = beanFactory.getBean(beanName);
                ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get((ApplicationContext)applicationContext, bean, beanName);
                if (propertiesBean == null) continue;
                propertiesBeans.put(beanName, propertiesBean);
            }
            catch (Exception exception) {}
        }
        return propertiesBeans;
    }

    private static boolean isConfigurationPropertiesBean(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            if (beanFactory.getBeanDefinition(beanName).isAbstract()) {
                return false;
            }
            if (beanFactory.findAnnotationOnBean(beanName, ConfigurationProperties.class) != null) {
                return true;
            }
            Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(beanFactory, beanName);
            return ConfigurationPropertiesBean.findMergedAnnotation(factoryMethod, ConfigurationProperties.class).isPresent();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    public static @Nullable ConfigurationPropertiesBean get(ApplicationContext applicationContext, Object bean, String beanName) {
        Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(applicationContext, beanName);
        Bindable<Object> bindTarget = ConfigurationPropertiesBean.createBindTarget(bean, bean.getClass(), factoryMethod);
        if (bindTarget == null) {
            return null;
        }
        if ((bindTarget = bindTarget.withBindMethod(BindMethodAttribute.get(applicationContext, beanName))).getBindMethod() == null && factoryMethod != null) {
            bindTarget = bindTarget.withBindMethod(JAVA_BEAN_BIND_METHOD);
        }
        if (bindTarget.getBindMethod() != VALUE_OBJECT_BIND_METHOD) {
            bindTarget = bindTarget.withExistingValue(bean);
        }
        return ConfigurationPropertiesBean.create(beanName, bean, bindTarget);
    }

    private static @Nullable Method findFactoryMethod(ApplicationContext applicationContext, String beanName) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            return ConfigurationPropertiesBean.findFactoryMethod(configurableContext, beanName);
        }
        return null;
    }

    private static @Nullable Method findFactoryMethod(ConfigurableApplicationContext applicationContext, String beanName) {
        return ConfigurationPropertiesBean.findFactoryMethod(applicationContext.getBeanFactory(), beanName);
    }

    private static @Nullable Method findFactoryMethod(ConfigurableListableBeanFactory beanFactory, String beanName) {
        BeanDefinition beanDefinition;
        if (beanFactory.containsBeanDefinition(beanName) && (beanDefinition = beanFactory.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
            RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
            return rootBeanDefinition.getResolvedFactoryMethod();
        }
        return null;
    }

    static ConfigurationPropertiesBean forValueObject(Class<?> beanType, String beanName) {
        Bindable<Object> bindTarget = ConfigurationPropertiesBean.createBindTarget(null, beanType, null);
        Assert.state((bindTarget != null && ConfigurationPropertiesBean.deduceBindMethod(bindTarget) == VALUE_OBJECT_BIND_METHOD ? 1 : 0) != 0, () -> "Bean '" + beanName + "' is not a @ConfigurationProperties value object");
        return ConfigurationPropertiesBean.create(beanName, null, bindTarget.withBindMethod(VALUE_OBJECT_BIND_METHOD));
    }

    private static @Nullable Bindable<Object> createBindTarget(@Nullable Object bean, Class<?> beanType, @Nullable Method factoryMethod) {
        ResolvableType type = factoryMethod != null ? ResolvableType.forMethodReturnType((Method)factoryMethod) : ResolvableType.forClass(beanType);
        Annotation[] annotations = ConfigurationPropertiesBean.findAnnotations(bean, beanType, factoryMethod);
        return annotations != null ? Bindable.of(type).withAnnotations(annotations) : null;
    }

    private static Annotation @Nullable [] findAnnotations(@Nullable Object instance, Class<?> type, @Nullable Method factory) {
        Annotation[] annotationArray;
        ConfigurationProperties annotation = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, ConfigurationProperties.class);
        if (annotation == null) {
            return null;
        }
        Validated validated = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, Validated.class);
        if (validated != null) {
            Annotation[] annotationArray2 = new Annotation[2];
            annotationArray2[0] = annotation;
            annotationArray = annotationArray2;
            annotationArray2[1] = validated;
        } else {
            Annotation[] annotationArray3 = new Annotation[1];
            annotationArray = annotationArray3;
            annotationArray3[0] = annotation;
        }
        return annotationArray;
    }

    private static <A extends Annotation> @Nullable A findAnnotation(@Nullable Object instance, Class<?> type, @Nullable Method factory, Class<A> annotationType) {
        MergedAnnotation annotation = MergedAnnotation.missing();
        if (factory != null) {
            annotation = ConfigurationPropertiesBean.findMergedAnnotation(factory, annotationType);
        }
        if (!annotation.isPresent()) {
            annotation = ConfigurationPropertiesBean.findMergedAnnotation(type, annotationType);
        }
        if (!annotation.isPresent() && AopUtils.isAopProxy((Object)instance)) {
            annotation = MergedAnnotations.from((AnnotatedElement)AopUtils.getTargetClass((Object)instance), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType);
        }
        return (A)(annotation.isPresent() ? annotation.synthesize() : null);
    }

    private static <A extends Annotation> MergedAnnotation<A> findMergedAnnotation(@Nullable AnnotatedElement element, Class<A> annotationType) {
        return element != null ? MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType) : MergedAnnotation.missing();
    }

    @Contract(value="_, _, !null -> !null")
    private static @Nullable ConfigurationPropertiesBean create(String name, @Nullable Object instance, @Nullable Bindable<Object> bindTarget) {
        return bindTarget != null ? new ConfigurationPropertiesBean(name, instance, bindTarget) : null;
    }

    static BindMethod deduceBindMethod(Class<?> type) {
        return ConfigurationPropertiesBean.deduceBindMethod(BindConstructorProvider.DEFAULT.getBindConstructor(type, false));
    }

    static BindMethod deduceBindMethod(Bindable<Object> bindable) {
        return ConfigurationPropertiesBean.deduceBindMethod(BindConstructorProvider.DEFAULT.getBindConstructor(bindable, false));
    }

    private static BindMethod deduceBindMethod(@Nullable Constructor<?> bindConstructor) {
        return bindConstructor != null ? VALUE_OBJECT_BIND_METHOD : JAVA_BEAN_BIND_METHOD;
    }
}

