/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.IOException;
import java.net.Socket;
import org.apache.nifi.remote.AbstractCommunicationsSession;
import org.apache.nifi.remote.io.socket.SocketInput;
import org.apache.nifi.remote.io.socket.SocketOutput;
import org.apache.nifi.remote.protocol.CommunicationsInput;
import org.apache.nifi.remote.protocol.CommunicationsOutput;

public class SocketCommunicationsSession
extends AbstractCommunicationsSession {
    private final Socket socket;
    private final SocketInput request;
    private final SocketOutput response;
    private int timeout = 30000;

    public SocketCommunicationsSession(Socket socket) throws IOException {
        this.socket = socket;
        this.request = new SocketInput(socket);
        this.response = new SocketOutput(socket);
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public CommunicationsInput getInput() {
        return this.request;
    }

    @Override
    public CommunicationsOutput getOutput() {
        return this.response;
    }

    @Override
    public void setTimeout(int millis) throws IOException {
        this.request.setTimeout(millis);
        this.response.setTimeout(millis);
        this.timeout = millis;
    }

    @Override
    public int getTimeout() throws IOException {
        return this.timeout;
    }

    @Override
    public void close() throws IOException {
        IOException suppressed = null;
        try {
            this.request.consume();
        }
        catch (IOException ioe) {
            suppressed = ioe;
        }
        try {
            this.socket.close();
        }
        catch (IOException ioe) {
            if (suppressed != null) {
                ioe.addSuppressed(suppressed);
            }
            throw ioe;
        }
        if (suppressed != null) {
            throw suppressed;
        }
    }

    @Override
    public boolean isDataAvailable() {
        return this.request.isDataAvailable();
    }

    @Override
    public long getBytesWritten() {
        return this.response.getBytesWritten();
    }

    @Override
    public long getBytesRead() {
        return this.request.getBytesRead();
    }

    @Override
    public void interrupt() {
        this.request.interrupt();
        this.response.interrupt();
    }
}

