/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.nifi.encrypt.CipherPropertyEncryptor;
import org.apache.nifi.encrypt.EncryptionException;

class KeyedCipherPropertyEncryptor
extends CipherPropertyEncryptor {
    private static final int INITIALIZATION_VECTOR_LENGTH = 16;
    private static final int GCM_TAG_LENGTH_BITS = 128;
    private static final int ARRAY_START = 0;
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private final SecretKey secretKey;
    private final SecureRandom secureRandom;
    private final String description;

    protected KeyedCipherPropertyEncryptor(SecretKey secretKey) {
        this.secretKey = secretKey;
        this.secureRandom = new SecureRandom();
        this.description = String.format("%s Key Algorithm [%s] Key Bytes [%d]", this.getClass().getSimpleName(), secretKey.getAlgorithm(), secretKey.getEncoded().length);
    }

    @Override
    protected Cipher getDecryptionCipher(byte[] encryptedBinary) {
        byte[] initializationVector = this.readInitializationVector(encryptedBinary);
        return this.getCipher(initializationVector, 2);
    }

    @Override
    protected Cipher getEncryptionCipher(byte[] encodedParameters) {
        return this.getCipher(encodedParameters, 1);
    }

    @Override
    protected byte[] getCipherBinary(byte[] encryptedBinary) {
        return Arrays.copyOfRange(encryptedBinary, 16, encryptedBinary.length);
    }

    @Override
    protected byte[] getEncodedParameters() {
        byte[] initializationVector = new byte[16];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }

    private Cipher getCipher(byte[] initializationVector, int cipherMode) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, initializationVector);
            cipher.init(cipherMode, (Key)this.secretKey, parameterSpec);
            return cipher;
        }
        catch (Exception e) {
            String message = String.format("Failed to get Cipher for Algorithm [%s]", CIPHER_ALGORITHM);
            throw new EncryptionException(message, e);
        }
    }

    private byte[] readInitializationVector(byte[] binary) {
        byte[] initializationVector = new byte[16];
        System.arraycopy(binary, 0, initializationVector, 0, 16);
        return initializationVector;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof KeyedCipherPropertyEncryptor) {
            KeyedCipherPropertyEncryptor encryptor = (KeyedCipherPropertyEncryptor)object;
            equals = Objects.equals(this.secretKey, encryptor.secretKey);
        }
        return equals;
    }

    public int hashCode() {
        return Objects.hash(this.secretKey);
    }

    public String toString() {
        return this.description;
    }
}

