/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.twig.editor.ui.options;

import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.twig.editor.actions.ToggleBlockCommentAction;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.NbBundle;

@NbBundle.Messages("TwigPanel.options.keywords.tabTitle=Frameworks & Tools")
@OptionsPanelController.Keywords(
    keywords = {
        "php", "twig"
    },
    location = UiUtils.OPTIONS_PATH,
    tabTitle = "#TwigPanel.options.keywords.tabTitle"
)
final class TwigPanel extends javax.swing.JPanel {

    private final TwigOptionsPanelController controller;
    private boolean firstOpening = true;

    TwigPanel(TwigOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        setDefaultValues();
        // TODO listen to changes in form fields and call controller.changed()
    }
    
    private void setDefaultValues() {
        ToggleBlockCommentAction.ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
        if (toggleCommentType == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
            asTwigEverywhereRadioButton.setSelected(true);
        } else {
            languageSensitiveRadioButton.setSelected(true);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        toggleCommentButtonGroup = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        asTwigEverywhereRadioButton = new javax.swing.JRadioButton();
        languageSensitiveRadioButton = new javax.swing.JRadioButton();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(TwigPanel.class, "TwigPanel.jLabel1.text")); // NOI18N

        toggleCommentButtonGroup.add(asTwigEverywhereRadioButton);
        asTwigEverywhereRadioButton.setMnemonic('t');
        org.openide.awt.Mnemonics.setLocalizedText(asTwigEverywhereRadioButton, org.openide.util.NbBundle.getMessage(TwigPanel.class, "TwigPanel.asTwigEverywhereRadioButton.text")); // NOI18N
        asTwigEverywhereRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                asTwigEverywhereRadioButtonActionPerformed(evt);
            }
        });

        toggleCommentButtonGroup.add(languageSensitiveRadioButton);
        languageSensitiveRadioButton.setMnemonic('l');
        org.openide.awt.Mnemonics.setLocalizedText(languageSensitiveRadioButton, org.openide.util.NbBundle.getMessage(TwigPanel.class, "TwigPanel.languageSensitiveRadioButton.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(asTwigEverywhereRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(languageSensitiveRadioButton)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(asTwigEverywhereRadioButton)
                    .addComponent(languageSensitiveRadioButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void asTwigEverywhereRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_asTwigEverywhereRadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_asTwigEverywhereRadioButtonActionPerformed

    void load() {
        if(firstOpening || !changed()) { // if panel is not modified by the user and he switches back to this panel, set to default
            firstOpening = false;
            ToggleBlockCommentAction.ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
            if (toggleCommentType == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
                asTwigEverywhereRadioButton.setSelected(true);
            } else {
                languageSensitiveRadioButton.setSelected(true);
            }
        }
    }

    void store() {
        ToggleBlockCommentAction.ToggleCommentType toggleCommentType;
        if (asTwigEverywhereRadioButton.isSelected()) {
            toggleCommentType = ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE;
        } else {
            toggleCommentType = ToggleBlockCommentAction.ToggleCommentType.LANGUAGE_SENSITIVE;
        }
        TwigOptions.getInstance().setToggleCommentType(toggleCommentType);
    }

    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }
    
    void cancel() {
        if (changed()) { // if panel is modified by the user and options window closes, discard any changes
            ToggleBlockCommentAction.ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
            if (toggleCommentType == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
                asTwigEverywhereRadioButton.setSelected(true);
            } else {
                languageSensitiveRadioButton.setSelected(true);
            }
        }
    }

    boolean changed() {
        if (TwigOptions.getInstance().getToggleCommentType() == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
            return !asTwigEverywhereRadioButton.isSelected();
        } 
        return !languageSensitiveRadioButton.isSelected();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton asTwigEverywhereRadioButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton languageSensitiveRadioButton;
    private javax.swing.ButtonGroup toggleCommentButtonGroup;
    // End of variables declaration//GEN-END:variables
}
