/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.html.presenters.webkit;

import java.io.PrintStream;
import java.util.Map.Entry;

final class Timeout implements Runnable {
    private final long timeout;
    private final Thread thread;

    Timeout(long timeout) {
        this.timeout = timeout;
        this.thread = new Thread(this, "Timeout Watcher");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(timeout);
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        System.err.println("Timeout in " + timeout + " ms");
        dumpThreads(System.err);
    }

    private static void dumpThreads(PrintStream ps) {
        for (Entry<Thread,StackTraceElement[]> e : Thread.getAllStackTraces().entrySet()) {
            ps.println("Thread " + e.getKey().getName() + ":");
            for (StackTraceElement t : e.getValue()) {
                ps.println("  " + t);
            }
        }
        ps.println();
    }
}
