/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class ChangeComponentProxy
implements Serializable {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ChangeComponentProxy.class);
    private transient Class<? extends UIComponent> _class;
    private String _className;
    private Object _state;
    private static final long serialVersionUID = 1L;

    public ChangeComponentProxy(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent == null) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONSTRUCT_CHANGECOMPONENTPROXY_WITH_NULL_UICOMPONENT"));
        }
        this._class = uiComponent.getClass();
        this._className = this._class.getName();
        this._state = uiComponent.saveState(facesContext);
    }

    public UIComponent createComponent() {
        UIComponent uic = null;
        Class<? extends UIComponent> clazz = this._getComponentClass();
        if (clazz == null) {
            return null;
        }
        try {
            uic = clazz.newInstance();
            uic.restoreState(FacesContext.getCurrentInstance(), this._state);
        }
        catch (InstantiationException ie) {
            _LOG.warning("ERR_CREATE_NEW_COMPONENT_INSTANCE", clazz.getName());
            _LOG.warning(ie);
        }
        catch (IllegalAccessException iae) {
            _LOG.warning("ERR_CREATE_NEW_COMPONENT_INSTANCE", clazz.getName());
            _LOG.warning(iae);
        }
        return uic;
    }

    private Class<? extends UIComponent> _getComponentClass() {
        Class<Object> clazz = this._class;
        if (clazz == null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                this._class = clazz = cl.loadClass(this._className);
            }
            catch (ClassNotFoundException e) {
                _LOG.severe(e);
            }
        }
        return clazz;
    }
}

