/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.xml.parse.BaseImageProviderRequestParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class ColorizedIconParser
extends BaseImageProviderRequestParser {
    private static final int _PROPERTY_COUNT = 7;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColorizedIconParser.class);

    public ColorizedIconParser() {
        super(7);
    }

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        Class laf;
        block7: {
            String newLafString;
            super.startElement(context, namespaceURI, localName, attrs);
            String source = this.getRequiredAttribute(context, attrs, "source");
            if (source != null) {
                this.setProperty(ImageConstants.SOURCE_KEY, source);
            } else {
                this.__errorOccured();
            }
            String lafString = attrs.getValue("laf");
            if (lafString == null) {
                lafString = "org.apache.myfaces.trinidadinternal.ui.laf.oracle.desktop.BrowserLookAndFeel";
            }
            if ((newLafString = ColorizedIconParser._mapOldLaf(lafString)) != null) {
                lafString = newLafString;
            }
            laf = null;
            try {
                laf = ClassLoaderUtils.loadClass((String)lafString);
            }
            catch (ClassNotFoundException e) {
                if (!_LOG.isWarning()) break block7;
                _LOG.warning("laf \"" + lafString + "\" not found.");
            }
        }
        this.setProperty(ImageConstants.LAF_KEY, laf);
        if (laf == null) {
            this.__errorOccured();
        }
    }

    private static String _mapOldLaf(String lafString) {
        if ("org.apache.myfaces.trinidadinternal.ui.laf.browser.BrowserLookAndFeel".equals(lafString)) {
            return "org.apache.myfaces.trinidadinternal.ui.laf.oracle.desktop.BrowserLookAndFeel";
        }
        return null;
    }

    @Override
    protected boolean isColorElement(String namespaceURI, String localName) {
        if ("darkColor".equals(localName) || "darkAccentColor".equals(localName)) {
            return true;
        }
        return super.isColorElement(namespaceURI, localName);
    }

    @Override
    protected Object getColorKey(String namespaceURI, String localName) {
        if ("darkColor".equals(localName)) {
            return ImageConstants.DARK_COLOR_KEY;
        }
        if ("darkAccentColor".equals(localName)) {
            return ImageConstants.DARK_ACCENT_COLOR_KEY;
        }
        if ("background".equals(localName)) {
            return ImageConstants.DARK_COLOR_KEY;
        }
        return super.getColorKey(namespaceURI, localName);
    }
}

