/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.awt.Color;
import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.cache.PropertiesFilter;
import org.apache.myfaces.trinidadinternal.image.cache.WrappingMap;
import org.apache.myfaces.trinidadinternal.image.laf.browser.ButtonPainter;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;

public class CompositeButtonPropertiesFilter
implements PropertiesFilter {
    @Override
    public Map<Object, Object> filterProperties(ImageContext context, Map<Object, Object> properties) {
        return new Defaults(context, properties);
    }

    private static class Defaults
    extends WrappingMap<Object, Object>
    implements ImageConstants {
        private ImageContext _context;
        private FontProxy _font;
        private static final String _DEFAULT_FONT_NAME = "dialog";

        public Defaults(ImageContext context, Map<Object, Object> properties) {
            super(properties);
            this._context = context;
        }

        @Override
        public Object get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                FontProxy font;
                if (key.equals(ImageConstants.FONT_KEY) && value instanceof FontProxy && (font = (FontProxy)value).getName() == null) {
                    if (this._font == null) {
                        this._font = new FontProxy(_DEFAULT_FONT_NAME, font.getStyle(), font.getSize());
                    }
                    value = this._font;
                }
                return value;
            }
            Map<Object, Object> properties = this.getWrappedMap();
            if (key.equals(ImageConstants.FOREGROUND_KEY)) {
                return this._getDefaultForeground(properties);
            }
            if (key.equals(ImageConstants.BACKGROUND_KEY)) {
                return this._getDefaultBackground(properties);
            }
            if (key.equals(ImageConstants.FONT_KEY)) {
                return ButtonPainter.getDefaultFont();
            }
            if (key.equals(ImageConstants.BORDER_COLOR_KEY)) {
                return this._getDefaultBorderColor(properties);
            }
            return null;
        }

        private Color _getDefaultForeground(Map<Object, Object> properties) {
            return ButtonPainter.getDefaultForeground(this._context, this._isDisabled(properties));
        }

        private Color _getDefaultBackground(Map<Object, Object> properties) {
            return ButtonPainter.getDefaultBackground(this._context, this._isDisabled(properties));
        }

        private boolean _isDisabled(Map<Object, Object> properties) {
            Boolean disabled = (Boolean)properties.get(DISABLED_KEY);
            if (disabled == null) {
                return false;
            }
            return disabled;
        }

        private Color _getDefaultBorderColor(Map<Object, Object> properties) {
            return ButtonPainter.getDefaultBorderColor(this._context, this._isDisabled(properties));
        }
    }
}

