// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIStars;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import jakarta.annotation.Generated;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;

/**
 Renders a star rating component.
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.StarsTagDeclaration}.
 */
@Generated("component.stg")
public class UIStars
    extends AbstractUIStars  {

  private static final Tags TAG = Tags.stars;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "jakarta.faces.Input";

  private static final Collection<String> EVENT_NAMES = Arrays.asList("change", "input", "click", "dblclick");

  @Override
  public Collection<String> getEventNames() {
    return EVENT_NAMES;
  }

  @Override
  public String getDefaultEventName() {
    return "change";
  }


  enum PropertyKeys {
    markup,
    max,
    labelLayout,
    messagePosition,
    focus,
    tabIndex,
    label,
    help,
    autoSpacing,
    readonly,
    helpPosition,
    accessKey,
    customClass,
    disabled,
    tip,
    placeholder,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  The maximum value must be &gt; '0'. Default is '5'.
   To split stars, set a higher maximum value.
   E.g. set '10' for half stars, set '20' for quarter stars.

  */
  public java.lang.Integer getMax() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.max);
    if (value != null) {
      return value.intValue();
    }
    return null;
  }

  public void setMax(java.lang.Integer max) {
    getStateHelper().put(PropertyKeys.max, max);
  }

  /**
  Defines the position of the label relative to the field.
   The default is flexLeft, if the label is set, or none, if the label isn't set.
   Set to 'skip' to avoid surrounding label container.
   Hint for tc:out: set also compact=true to render only text (without html tags).

  */
  public org.apache.myfaces.tobago.component.LabelLayout getLabelLayout() {
    org.apache.myfaces.tobago.component.LabelLayout labelLayout = (org.apache.myfaces.tobago.component.LabelLayout) getStateHelper().eval(PropertyKeys.labelLayout);
    if (labelLayout != null) {
      return labelLayout;
    }
    return getLabel() == null
          ? LabelLayout.none
          : LabelLayout.valueOf(org.apache.myfaces.tobago.context.TobagoContext.getInstance(getFacesContext()).getTheme().getTagAttributeDefault(TAG, "labelLayout"));
  }

  public void setLabelLayout(org.apache.myfaces.tobago.component.LabelLayout labelLayout) {
    getStateHelper().put(PropertyKeys.labelLayout, labelLayout);
  }

  /**
  Defines the position and the appearance of additional faces messages (like error message or help message) on a
   component.
   The default is popoverRight.

  */
  public org.apache.myfaces.tobago.component.DecorationPosition getMessagePosition() {
    org.apache.myfaces.tobago.component.DecorationPosition messagePosition = (org.apache.myfaces.tobago.component.DecorationPosition) getStateHelper().eval(PropertyKeys.messagePosition);
    if (messagePosition != null) {
      return messagePosition;
    }
    return DecorationPosition.valueOf(org.apache.myfaces.tobago.context.TobagoContext.getInstance(getFacesContext()).getTheme().getTagAttributeDefault(TAG, "messagePosition"));
  }

  public void setMessagePosition(org.apache.myfaces.tobago.component.DecorationPosition messagePosition) {
    getStateHelper().put(PropertyKeys.messagePosition, messagePosition);
  }

  /**
  Flag indicating this component should receive the focus.
  <br>Default: <code>false</code>
  */
  public boolean isFocus() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.focus);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setFocus(boolean focus) {
    getStateHelper().put(PropertyKeys.focus, focus);
  }

  /**
  Controls the navigation of the focus through the
   input controls on a page with the Tab-Key.
   The navigation starts from the element with
   the lowest tabIndex value to the element with the highest value.
   Elements that have identical tabIndex values should be navigated
   in the order they appear in the character stream
   Elements that are disabled or with a negative tabIndex
   do not participate in the tabbing order.

  */
  public java.lang.Integer getTabIndex() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.tabIndex);
    if (value != null) {
      return value.intValue();
    }
    return null;
  }

  public void setTabIndex(java.lang.Integer tabIndex) {
    getStateHelper().put(PropertyKeys.tabIndex, tabIndex);
  }

  /**
  A localized user presentable label for this component.

  */
  public java.lang.String getLabel() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.label);
  }

  public void setLabel(java.lang.String label) {
    getStateHelper().put(PropertyKeys.label, label);
  }

  /**
  Text value to display as a help.

  */
  public java.lang.String getHelp() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.help);
  }

  public void setHelp(java.lang.String help) {
    getStateHelper().put(PropertyKeys.help, help);
  }

  /**
  Automatically add spacing (margins/paddings) to the component for better positioning.
   Default is 'true' except the component is inside a:
   - header
   - footer
   - bar
   - sheet
   - tree
   - link group
   - button group
   - before facet
   - after facet
   - label facet
   - bar facet

  */
  public Boolean getAutoSpacing() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.autoSpacing);
    if (bool != null) {
      return bool;
    }
    return null;
  }

  public void setAutoSpacing(Boolean autoSpacing) {
    getStateHelper().put(PropertyKeys.autoSpacing, autoSpacing);
  }

  /**
  Flag indicating that this component will prohibit changes by the user.
  <br>Default: <code>false</code>
  */
  public boolean isReadonly() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.readonly);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setReadonly(boolean readonly) {
    getStateHelper().put(PropertyKeys.readonly, readonly);
  }

  /**
  Defines the position and the appearance of a help message on a component.
   The default is popoverRight.

  */
  public org.apache.myfaces.tobago.component.DecorationPosition getHelpPosition() {
    org.apache.myfaces.tobago.component.DecorationPosition helpPosition = (org.apache.myfaces.tobago.component.DecorationPosition) getStateHelper().eval(PropertyKeys.helpPosition);
    if (helpPosition != null) {
      return helpPosition;
    }
    return DecorationPosition.valueOf(org.apache.myfaces.tobago.context.TobagoContext.getInstance(getFacesContext()).getTheme().getTagAttributeDefault(TAG, "helpPosition"));
  }

  public void setHelpPosition(org.apache.myfaces.tobago.component.DecorationPosition helpPosition) {
    getStateHelper().put(PropertyKeys.helpPosition, helpPosition);
  }

  /**
  The access key of this control.

  */
  public java.lang.Character getAccessKey() {
    return (java.lang.Character) getStateHelper().eval(PropertyKeys.accessKey);
  }

  public void setAccessKey(java.lang.Character accessKey) {
    getStateHelper().put(PropertyKeys.accessKey, accessKey);
  }

  /**
  Sets a CSS class in its parent, if the parent supports it.

   Which this feature it is possible to put a CSS class name into a component with the &lt;tc:style&gt; tag. Example:

   <pre>
   &lt;tc:in&gt;
     &lt;tc:style customClass="my-emphasized"/&gt;
   &lt;/tc:in&gt;
   </pre>

   One capability is, to used external CSS libs.
   <br>
   This feature should not be used imprudent.
   Because it might be unstable against changes in the renderered HTML code.

  */
  public org.apache.myfaces.tobago.renderkit.css.CustomClass getCustomClass() {
    return (org.apache.myfaces.tobago.renderkit.css.CustomClass) getStateHelper().eval(PropertyKeys.customClass);
  }

  public void setCustomClass(org.apache.myfaces.tobago.renderkit.css.CustomClass customClass) {
    getStateHelper().put(PropertyKeys.customClass, customClass);
  }

  /**
  Flag indicating that this element is disabled.
  <br>Default: <code>false</code>
  */
  public boolean isDisabled() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.disabled);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setDisabled(boolean disabled) {
    getStateHelper().put(PropertyKeys.disabled, disabled);
  }

  /**
  Text value to display as tooltip.

  */
  public java.lang.String getTip() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.tip);
  }

  public void setTip(java.lang.String tip) {
    getStateHelper().put(PropertyKeys.tip, tip);
  }

  /**
  The placeholder value is displayed if no star is set by the user.
   Value must be between '0' and '5'.
   The placeholder can show values which are not selectable by the user.
   E.g. if only full stars are available for the user, the placeholder can show a 4.6 star rating.

  */
  public java.lang.Double getPlaceholder() {
    return (java.lang.Double) getStateHelper().eval(PropertyKeys.placeholder);
  }

  public void setPlaceholder(java.lang.Double placeholder) {
    getStateHelper().put(PropertyKeys.placeholder, placeholder);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}