/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUIFigure;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class FigureRenderer<T extends AbstractUIFigure>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.FIGURE);
        writer.writeClassAttribute(BootstrapClass.FIGURE, component.getCustomClass());
        String tip = ((AbstractUIPanelBase)component).getTip();
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.FIGURE_IMG);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        UIComponent label = ComponentUtils.getFacet(component, Facets.label);
        String labelString = ((AbstractUIFigure)component).getLabel();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        if (labelString != null || label != null) {
            writer.startElement(HtmlElements.FIGCAPTION);
            writer.writeClassAttribute(BootstrapClass.FIGURE_CAPTION);
            if (labelString != null) {
                writer.writeText(labelString);
            }
            if (label != null) {
                this.insideBegin(facesContext, Facets.label);
                label.encodeAll(facesContext);
                this.insideEnd(facesContext, Facets.label);
            }
            writer.endElement(HtmlElements.FIGCAPTION);
        }
        writer.endElement(HtmlElements.FIGURE);
    }
}

