/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.invoke.MethodHandles;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int ONE_YEAR_IN_SECONDS = 31536000;

    private CookieUtils() {
    }

    public static String getThemeNameFromCookie(HttpServletRequest request) {
        String themeName = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("cookie name  ='{}'", (Object)cookie.getName());
                    LOG.debug("cookie value ='{}'", (Object)cookie.getValue());
                    LOG.debug("cookie path  ='{}'", (Object)cookie.getPath());
                }
                if (!"tobago.theme".equals(cookie.getName())) continue;
                themeName = cookie.getValue();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("theme from cookie {}='{}'", (Object)"tobago.theme", (Object)themeName);
                break;
            }
        }
        return themeName;
    }

    public static void setThemeNameToCookie(HttpServletRequest request, HttpServletResponse response, String themeName) {
        String path = request.getContextPath();
        path = StringUtils.isBlank(path) ? "/" : path;
        boolean found = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"tobago.theme".equals(cookie.getName())) continue;
                if (found) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found more than one cookie {}, try to remove them...", (Object)"tobago.theme");
                    }
                    cookie.setMaxAge(0);
                } else {
                    found = true;
                    if (StringUtils.notEquals(cookie.getValue(), themeName)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("update theme {} -> {}", (Object)cookie.getValue(), (Object)themeName);
                        }
                        cookie.setValue(themeName);
                    }
                    if (StringUtils.notEquals(cookie.getPath(), path)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("update path  {} -> {}", (Object)cookie.getPath(), (Object)path);
                        }
                        cookie.setPath(path);
                    }
                    cookie.setMaxAge(31536000);
                }
                cookie.setSecure(request.isSecure());
                response.addCookie(cookie);
            }
        }
        if (!found) {
            Cookie cookie = new Cookie("tobago.theme", themeName);
            cookie.setPath(path);
            cookie.setMaxAge(31536000);
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
        }
    }

    public static void removeThemeNameCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"tobago.theme".equals(cookie.getName())) continue;
                cookie.setMaxAge(0);
                cookie.setValue(null);
                cookie.setSecure(request.isSecure());
                response.addCookie(cookie);
            }
        }
    }
}

