/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UILabel;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(LabelTag.class);
    private String forComponent;
    private ValueExpression tip;
    private ValueExpression value;
    private ValueExpression markup;
    private ValueExpression accessKey;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Label";
    }

    public String getRendererType() {
        return "Label";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UILabel component = (UILabel)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.forComponent != null) {
            component.setFor(this.forComponent);
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.accessKey != null) {
            if (!this.accessKey.isLiteralText()) {
                component.setValueExpression("accessKey", this.accessKey);
            } else {
                component.setAccessKey(Character.valueOf(this.accessKey.getExpressionString().charAt(0)));
            }
        }
    }

    public String getFor() {
        return this.forComponent;
    }

    public void setFor(String forComponent) {
        this.forComponent = forComponent;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(ValueExpression accessKey) {
        this.accessKey = accessKey;
    }

    public void release() {
        super.release();
        this.forComponent = null;
        this.tip = null;
        this.value = null;
        this.markup = null;
        this.accessKey = null;
    }
}

