/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.el;

import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(UserWrapper.class);
    private Map roles = new RolesMap();

    public Principal getPrincipal() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Principal principal = facesContext.getExternalContext().getUserPrincipal();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getPrincipal(): {}", (Object)principal);
        }
        return principal;
    }

    public Map getRoles() {
        return this.roles;
    }

    private static class RolesMap
    implements Map {
        private RolesMap() {
        }

        public Object get(Object key) {
            String role = (String)key;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            boolean inRole = facesContext.getExternalContext().isUserInRole(role);
            if (LOG.isDebugEnabled()) {
                LOG.debug("is in role '{}': {}", key, (Object)inRole);
            }
            return inRole;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

