/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class OutRenderer
extends LayoutComponentRendererBase {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIOut out = (UIOut)component;
        String text = RenderUtils.currentValue((UIComponent)out);
        if (text == null) {
            text = "";
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        boolean escape = out.isEscape();
        boolean createSpan = out.isCreateSpan();
        if (createSpan) {
            String id = out.getClientId(facesContext);
            writer.startElement("span", (UIComponent)out);
            writer.writeIdAttribute(id);
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)out);
            Style style = new Style(facesContext, (LayoutBase)out);
            writer.writeStyleAttribute(style);
            writer.writeClassAttribute(Classes.create((UIComponent)out));
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)out);
            if (title != null) {
                writer.writeAttribute("title", title, true);
            }
        }
        if (escape) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                writer.writeText(token);
                if (!tokenizer.hasMoreTokens()) continue;
                writer.startElement("br", null);
                writer.endElement("br");
            }
        } else {
            writer.writeText((Object)"", null);
            if ("auto".equals(out.getSanitize())) {
                Sanitizer sanitizer = TobagoConfig.getInstance((FacesContext)facesContext).getSanitizer();
                text = sanitizer.sanitize(text);
            }
            writer.write(text);
        }
        if (createSpan) {
            writer.endElement("span");
        }
    }
}

