/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIProgress;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIProgress progress = (UIProgress)component;
        BoundedRangeModel model = (BoundedRangeModel)progress.getValue();
        if (model == null) {
            LOG.warn("'null' value found! Using dummy Model instead!");
            model = new DefaultBoundedRangeModel(0, 1, 0, 100);
        }
        int diff = model.getMaximum() - model.getMinimum();
        Object title = progress.getAttributes().get("tip");
        if (title == null && diff > 0) {
            title = Integer.toString(100 * model.getValue() / diff) + " %";
        }
        Style style = new Style(facesContext, (LayoutBase)progress);
        Measure width = style.getWidth();
        Measure valueWidth = diff > 0 ? width.multiply(model.getValue()).divide(diff) : width;
        Style valueStyle = new Style();
        valueStyle.setHeight(style.getHeight());
        valueStyle.setWidth(valueWidth);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("div", (UIComponent)progress);
        writer.writeClassAttribute(Classes.create((UIComponent)progress));
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)progress);
        writer.writeStyleAttribute(style);
        if (title != null) {
            writer.writeAttribute("title", String.valueOf(title), true);
        }
        UIComponent facet = progress.getFacet("complete");
        if (model.getValue() == model.getMaximum() && facet instanceof UICommand) {
            HtmlRendererUtils.renderCommandFacet((UIComponent)progress, facesContext, writer);
        }
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)progress, (String)"value"));
        writer.writeStyleAttribute(valueStyle);
        writer.endElement("div");
        writer.endElement("div");
    }
}

