/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.managedproperty;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.faces.FacesException;
import jakarta.faces.annotation.ManagedProperty;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.myfaces.cdi.managedproperty.ManagedPropertyInfo;
import org.apache.myfaces.cdi.util.AbstractDynamicProducer;
import org.apache.myfaces.util.lang.ClassUtils;

@ApplicationScoped
public class ManagedPropertyProducer
extends AbstractDynamicProducer<Object> {
    public ManagedPropertyProducer(BeanManager beanManager, ManagedPropertyInfo typeInfo) {
        super(beanManager);
        Class beanClass = typeInfo.getType() instanceof ParameterizedType ? ClassUtils.simpleClassForName(((ParameterizedType)typeInfo.getType()).getRawType().getTypeName()) : ClassUtils.simpleJavaTypeToClass(typeInfo.getType().getTypeName());
        super.id(String.valueOf(typeInfo.getType()) + "_" + typeInfo.getExpression()).scope(Dependent.class).qualifiers(new ManagedPropertyAnnotationLiteral(typeInfo.getExpression())).types(new Type[]{typeInfo.getType(), Object.class}).beanClass(beanClass).create((CreationalContext<T> e) -> this.createManagedProperty((CreationalContext<Object>)e, typeInfo));
    }

    protected Object createManagedProperty(CreationalContext<Object> cc, ManagedPropertyInfo typeInfo) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new FacesException("@ManagedProperty(\"" + typeInfo.getExpression() + "\") can only be resolved in a Faces request!");
        }
        return facesContext.getApplication().evaluateExpressionGet(facesContext, typeInfo.getExpression(), this.getBeanClass());
    }

    class ManagedPropertyAnnotationLiteral
    extends AnnotationLiteral<ManagedProperty>
    implements ManagedProperty {
        private static final long serialVersionUID = 1L;
        private String value;

        public ManagedPropertyAnnotationLiteral(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

