/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.content.fractal;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.apache.chemistry.opencmis.inmemory.content.fractal.ComplexPoint;
import org.apache.chemistry.opencmis.inmemory.content.fractal.ComplexRectangle;
import org.apache.chemistry.opencmis.inmemory.content.fractal.FractalCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(FractalGenerator.class);
    private static final int ZOOM_STEPS_PER_BATCH = 10;
    private static final int DEFAULT_MAX_ITERATIONS = 33;
    private static final ComplexRectangle INITIAL_RECT = new ComplexRectangle(-2.1, 1.1, -1.3, 1.3);
    private static final ComplexRectangle INITIAL_JULIA_RECT = new ComplexRectangle(-2.0, 2.0, -2.0, 2.0);
    private static final int INITIAL_ITERATIONS = 33;
    private Map<String, int[]> colorTable;
    private static final String COLORS_BLACK_AND_WHITE = "black & white";
    private static final String COLORS_BLUE_ICE = "blue ice";
    private static final String COLORS_FUNKY = "funky";
    private static final String COLORS_PASTEL = "pastel";
    private static final String COLORS_PSYCHEDELIC = "psychedelic";
    private static final String COLORS_PURPLE_HAZE = "purple haze";
    private static final String COLORS_RADICAL = "radical";
    private static final String COLORS_RAINBOW = "rainbow";
    private static final String COLORS_RAINBOWS = "rainbows";
    private static final String COLORS_SCINTILLATION = "scintillation";
    private static final String COLORS_WARPED = "warped";
    private static final String COLORS_WILD = "wild";
    private static final String COLORS_ZEBRA = "zebra";
    private static final String[] colorSchemes = new String[]{"black & white", "blue ice", "funky", "pastel", "psychedelic", "purple haze", "radical", "rainbow", "rainbows", "scintillation", "warped", "wild", "zebra"};
    private static final int IMAGE_HEIGHT = 512;
    private static final int IMAGE_WIDTH = 512;
    private static final int NUM_COLORS = 512;
    private FractalCalculator calculator;
    private int previousIterations = 1;
    private int maxIterations;
    private String color;
    private int newRowTile;
    private int newColTile;
    private int parts = 16;
    private int stepInBatch = 0;
    private ComplexRectangle rect;
    private ComplexPoint juliaPoint;

    public FractalGenerator() {
        this.reset();
    }

    private void reset() {
        this.rect = new ComplexRectangle(-1.6, -1.2, -0.1, 0.1);
        this.juliaPoint = null;
        this.maxIterations = 33;
        SecureRandom ran = new SecureRandom();
        this.color = colorSchemes[ran.nextInt(colorSchemes.length)];
        this.parts = ran.nextInt(13) + 3;
        LOG.debug("Parts: " + this.parts);
        this.maxIterations = 33;
        LOG.debug("Original rect : (" + this.rect.getRMin() + "r," + this.rect.getRMax() + "r, " + this.rect.getIMin() + "i, " + this.rect.getIMax() + "i)");
        this.randomizeRect(this.rect);
    }

    public ByteArrayOutputStream generateFractal() throws IOException {
        ByteArrayOutputStream bos = null;
        if (this.stepInBatch == 10) {
            this.stepInBatch = 0;
            this.reset();
        }
        ++this.stepInBatch;
        LOG.debug("Generating rect no " + this.stepInBatch + ": (" + this.rect.getRMin() + "r," + this.rect.getRMax() + "r, " + this.rect.getIMin() + "i, " + this.rect.getIMax() + "i)");
        LOG.debug("   width: " + this.rect.getWidth() + " height: " + this.rect.getHeight());
        bos = this.genFractal(this.rect, this.juliaPoint);
        double r1New = this.rect.getWidth() * (double)this.newColTile / (double)this.parts + this.rect.getRMin();
        double r2New = this.rect.getWidth() * (double)(this.newColTile + 1) / (double)this.parts + this.rect.getRMin();
        double i1New = this.rect.getIMax() - this.rect.getHeight() * (double)this.newRowTile / (double)this.parts;
        double i2New = this.rect.getIMax() - this.rect.getHeight() * (double)(this.newRowTile + 1) / (double)this.parts;
        this.rect.set(r1New, r2New, i1New, i2New);
        this.randomizeRect(this.rect);
        LOG.debug("Done generating fractals.");
        return bos;
    }

    private void randomizeRect(ComplexRectangle rect) {
        SecureRandom rnd = new SecureRandom();
        double jitterFactor = 0.15;
        double ran = rnd.nextDouble() * jitterFactor + (1.0 - jitterFactor);
        double width = rect.getWidth() * ran;
        ran = rnd.nextDouble() * jitterFactor + (1.0 - jitterFactor);
        double height = rect.getHeight() * ran;
        ran = rnd.nextDouble() * jitterFactor + (1.0 - jitterFactor);
        double r1 = (rect.getWidth() - width) * ran + rect.getRMin();
        ran = rnd.nextDouble() * jitterFactor + (1.0 - jitterFactor);
        double i1 = (rect.getHeight() - height) * ran + rect.getIMin();
        rect.set(r1, r1 + width, i1, i1 + height);
    }

    public ByteArrayOutputStream genFractal(ComplexRectangle rect, ComplexPoint juliaPoint) throws IOException {
        boolean isJulia = null != juliaPoint;
        this.expandRectToFitImage(rect);
        this.initializeColors();
        this.maxIterations = this.maybeGuessMaxIterations(this.maxIterations, rect, isJulia);
        LOG.debug("using " + this.maxIterations + " iterations.");
        this.detectDeepZoom(rect);
        this.calculator = new FractalCalculator(rect, this.maxIterations, 512, 512, this.getCurrentColorMap(), juliaPoint);
        int[][] iterations = this.calculator.calcFractal();
        BufferedImage image = this.calculator.mapItersToColors(iterations);
        this.findNewRect(image, iterations);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(204800);
        ImageOutputStream ios = ImageIO.createImageOutputStream(bos);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
        ImageWriter imageWriter = writers.next();
        JPEGImageWriteParam params = new JPEGImageWriteParam(Locale.getDefault());
        params.setCompressionMode(2);
        params.setCompressionQuality(0.9f);
        imageWriter.setOutput(ios);
        imageWriter.write(null, new IIOImage(image, null, null), params);
        ios.close();
        return bos;
    }

    protected int[] getCurrentColorMap() {
        return this.colorTable.get(this.getColor());
    }

    protected String getColor() {
        return this.color;
    }

    protected void expandRectToFitImage(ComplexRectangle complexRect) {
        double imageWHRatio = 1.0;
        double complexWHRatio = 1.0;
        double iMin = complexRect.getIMin();
        double iMax = complexRect.getIMax();
        double rMin = complexRect.getRMin();
        double rMax = complexRect.getRMax();
        double complexWidth = rMax - rMin;
        double complexHeight = iMax - iMin;
        imageWHRatio = 1.0;
        if (!(complexWidth > 0.0) || !(complexHeight > 0.0)) {
            return;
        }
        complexWHRatio = complexWidth / complexHeight;
        if (Double.compare(imageWHRatio, complexWHRatio) == 0) {
            return;
        }
        if (imageWHRatio < complexWHRatio) {
            double newHeight = complexWidth / imageWHRatio;
            double heightDifference = Math.abs(newHeight - complexHeight);
            iMin -= heightDifference / 2.0;
            iMax += heightDifference / 2.0;
        } else {
            double newWidth = complexHeight * imageWHRatio;
            double widthDifference = Math.abs(newWidth - complexWidth);
            rMin -= widthDifference / 2.0;
            rMax += widthDifference / 2.0;
        }
        complexRect.set(rMin, rMax, iMin, iMax);
    }

    private int guessNewMaxIterations(ComplexRectangle cr, boolean isJulia) {
        double logZoom;
        double magnitude;
        double zoom = INITIAL_RECT.getWidth() / cr.getWidth();
        if (zoom < 1.0) {
            zoom = 1.0;
        }
        if ((magnitude = (logZoom = Math.log(zoom)) / 2.3 - 2.0) < 1.0) {
            magnitude = 1.0;
        }
        double iterations = 33.0 * (magnitude * logZoom + 1.0);
        if (isJulia) {
            iterations *= 2.0;
        }
        return (int)iterations;
    }

    private int maybeGuessMaxIterations(int maxIterations, ComplexRectangle cr, boolean isJulia) {
        if (this.previousIterations == maxIterations) {
            maxIterations = this.guessNewMaxIterations(cr, isJulia);
        }
        this.previousIterations = maxIterations;
        return maxIterations;
    }

    private boolean detectDeepZoom(ComplexRectangle cr) {
        double deltaDiv2 = cr.getWidth() / 1024.0;
        String min = "" + cr.getRMin();
        String minPlus = "" + (cr.getRMin() + deltaDiv2);
        if (Double.valueOf(min).doubleValue() == Double.valueOf(minPlus).doubleValue()) {
            LOG.warn("Deep Zoom...  Drawing resolution will be degraded ;-(");
            return true;
        }
        return false;
    }

    private void initializeColors() {
        int colorNum;
        this.colorTable = new HashMap<String, int[]>();
        int red = 255;
        int green = 255;
        int blue = 255;
        float hue = 1.0f;
        float saturation = 1.0f;
        float brightness = 1.0f;
        int[] colorMap = new int[512];
        for (colorNum = 511; colorNum >= 0; --colorNum) {
            colorMap[colorNum] = Color.white.getRGB();
        }
        this.colorTable.put(COLORS_BLACK_AND_WHITE, colorMap);
        blue = 255;
        colorMap = new int[512];
        for (colorNum = 511; colorNum >= 0; --colorNum) {
            red = (int)(255.0f * (float)colorNum / 512.0f) % 255;
            green = (int)(255.0f * (float)colorNum / 512.0f) % 255;
            colorMap[colorNum] = new Color(red, green, blue).getRGB();
        }
        this.colorTable.put(COLORS_BLUE_ICE, colorMap);
        colorMap = new int[512];
        for (colorNum = 511; colorNum >= 0; --colorNum) {
            red = (int)(1024.0f * (float)colorNum / 512.0f) % 255;
            green = (int)(512.0f * (float)colorNum / 512.0f) % 255;
            blue = (int)(256.0f * (float)colorNum / 512.0f) % 255;
            colorMap[512 - colorNum - 1] = new Color(red, green, blue).getRGB();
        }
        this.colorTable.put(COLORS_FUNKY, colorMap);
        brightness = 1.0f;
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)(colorNum * 4) / 512.0f % 512.0f;
            saturation = (float)(colorNum * 2) / 512.0f % 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_PASTEL, colorMap);
        saturation = 1.0f;
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)(colorNum * 5) / 512.0f % 512.0f;
            brightness = (float)(colorNum * 20) / 512.0f % 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_PSYCHEDELIC, colorMap);
        red = 255;
        blue = 255;
        colorMap = new int[512];
        for (colorNum = 511; colorNum >= 0; --colorNum) {
            green = (int)(255.0f * (float)colorNum / 512.0f) % 255;
            colorMap[512 - colorNum - 1] = new Color(red, green, blue).getRGB();
        }
        this.colorTable.put(COLORS_PURPLE_HAZE, colorMap);
        saturation = 1.0f;
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)(colorNum * 7) / 512.0f % 512.0f;
            brightness = (float)(colorNum * 49) / 512.0f % 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_RADICAL, colorMap);
        saturation = 1.0f;
        brightness = 1.0f;
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)colorNum / 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_RAINBOW, colorMap);
        saturation = 1.0f;
        brightness = 1.0f;
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)(colorNum * 5) / 512.0f % 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_RAINBOWS, colorMap);
        brightness = 1.0f;
        saturation = 1.0f;
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)(colorNum * 2) / 512.0f % 512.0f;
            brightness = (float)(colorNum * 5) / 512.0f % 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_SCINTILLATION, colorMap);
        colorMap = new int[512];
        for (colorNum = 511; colorNum >= 0; --colorNum) {
            red = (int)(1024.0f * (float)colorNum / 512.0f) % 255;
            green = (int)(256.0f * (float)colorNum / 512.0f) % 255;
            blue = (int)(512.0f * (float)colorNum / 512.0f) % 255;
            colorMap[512 - colorNum - 1] = new Color(red, green, blue).getRGB();
        }
        this.colorTable.put(COLORS_WARPED, colorMap);
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            hue = (float)(colorNum * 1) / 512.0f % 512.0f;
            saturation = (float)(colorNum * 2) / 512.0f % 512.0f;
            brightness = (float)(colorNum * 4) / 512.0f % 512.0f;
            colorMap[colorNum] = Color.HSBtoRGB(hue, saturation, brightness);
        }
        this.colorTable.put(COLORS_WILD, colorMap);
        colorMap = new int[512];
        for (colorNum = 0; colorNum < 512; ++colorNum) {
            colorMap[colorNum] = colorNum % 2 == 0 ? Color.white.getRGB() : Color.black.getRGB();
        }
        this.colorTable.put(COLORS_ZEBRA, colorMap);
    }

    private void findNewRect(BufferedImage image, int[][] iterations) {
        int newWidth = image.getWidth() / this.parts;
        int newHeight = image.getHeight() / this.parts;
        int i = 0;
        int j = 0;
        int noTiles = image.getWidth() / newWidth * (image.getHeight() / newHeight);
        double[] stdDev = new double[noTiles];
        int y = 0;
        while (y + newHeight <= image.getHeight()) {
            int x = 0;
            while (x + newWidth <= image.getWidth()) {
                Rectangle subRect = new Rectangle(x, y, newWidth, newHeight);
                stdDev[i * this.parts + j] = this.calcStdDev(iterations, subRect);
                ++j;
                x += newWidth;
            }
            ++i;
            j = 0;
            y += newHeight;
        }
        double max = 0.0;
        int index = 0;
        for (i = 0; i < noTiles; ++i) {
            if (!(stdDev[i] > max)) continue;
            index = i;
            max = stdDev[i];
        }
        this.newRowTile = index / this.parts;
        this.newColTile = index % this.parts;
    }

    private double calcStdDev(int[][] iterations, Rectangle rect) {
        int sum = 0;
        long sumSquare = 0L;
        for (int x = rect.x; x < rect.x + rect.width; ++x) {
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                int iters = iterations[x][y];
                sum += iters;
                sumSquare += (long)(iters * iters);
            }
        }
        int count = rect.width * rect.height;
        double mean = 0.0;
        mean = (double)sum / (double)count;
        return Math.sqrt((double)sumSquare / ((double)count - mean * mean));
    }
}

