/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import shaded.org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import shaded.org.eclipse.aether.internal.impl.TrackingFileManager;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.LocalArtifactRegistration;
import shaded.org.eclipse.aether.repository.LocalArtifactRequest;
import shaded.org.eclipse.aether.repository.LocalArtifactResult;
import shaded.org.eclipse.aether.repository.LocalMetadataRegistration;
import shaded.org.eclipse.aether.repository.LocalMetadataRequest;
import shaded.org.eclipse.aether.repository.LocalMetadataResult;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.repository.RepositoryPolicy;

public class PaxLocalRepositoryManager
implements LocalRepositoryManager {
    public static final String PROPERTY_UPDATE_RELEASES = "paxUrlAether.updateReleases";
    private final LocalRepositoryManager delegate;
    private final UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final TrackingFileManager trackingFileManager;
    private final String trackingFilename;

    public PaxLocalRepositoryManager(File basedir, LocalRepositoryManager delegate, UpdatePolicyAnalyzer updatePolicyAnalyzer, RemoteRepositoryManager remoteRepositoryManager, TrackingFileManager trackingFileManager) {
        this.delegate = delegate;
        this.updatePolicyAnalyzer = updatePolicyAnalyzer;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.trackingFileManager = trackingFileManager;
        this.trackingFilename = "_pax-url-aether-remote.repositories";
    }

    @Override
    public LocalRepository getRepository() {
        return this.delegate.getRepository();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.delegate.getPathForLocalArtifact(artifact);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteArtifact(artifact, repository, context);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.getPathForLocalMetadata(metadata);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteMetadata(metadata, repository, context);
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String localKey;
        File trackingFile;
        Properties props;
        LocalArtifactResult result = this.delegate.find(session, request);
        if (result.isAvailable() && !request.getArtifact().isSnapshot() && ((Boolean)session.getConfigProperties().get(PROPERTY_UPDATE_RELEASES)).booleanValue() && (props = this.trackingFileManager.read(trackingFile = this.getTrackingFile(result.getFile()))) != null && props.get(localKey = result.getFile().getName() + ">") == null) {
            for (RemoteRepository repo : request.getRepositories()) {
                RepositoryPolicy policy;
                long lastUpdated;
                String remoteKey = result.getFile().getName() + ">" + repo.getId();
                if (props.get(remoteKey) == null || !this.updatePolicyAnalyzer.isUpdatedRequired(session, lastUpdated = result.getFile().lastModified(), (policy = this.remoteRepositoryManager.getPolicy(session, repo, true, false)).getUpdatePolicy())) continue;
                result.setAvailable(false);
                result.setFile(null);
                result.setRepository(repo);
                break;
            }
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        this.delegate.add(session, request);
        if (!request.getArtifact().isSnapshot() && ((Boolean)session.getConfigProperties().get(PROPERTY_UPDATE_RELEASES)).booleanValue()) {
            String path = this.getPathForLocalArtifact(request.getArtifact());
            File artifactFile = new File(this.getRepository().getBasedir(), path);
            File trackingFile = this.getTrackingFile(artifactFile);
            String repoId = request.getRepository() == null ? "" : request.getRepository().getId();
            HashMap<String, String> updates = new HashMap<String, String>();
            updates.put(artifactFile.getName() + ">" + repoId, "");
            this.trackingFileManager.update(trackingFile, updates);
        }
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        return this.delegate.find(session, request);
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        this.delegate.add(session, request);
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }
}

