/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.http.header.EntityTag;

@BeanIgnore
public class EntityTags {
    public static final EntityTags EMPTY = new EntityTags("");
    private static final Cache<String, EntityTags> CACHE = Cache.of(String.class, EntityTags.class).build();
    private final EntityTag[] value;
    private final String string;

    public static EntityTags of(EntityTag ... value) {
        return value == null ? null : new EntityTags(value);
    }

    public static EntityTags of(String value) {
        return StringUtils.isEmpty((String)value) ? EMPTY : (EntityTags)CACHE.get((Object)value, () -> new EntityTags(value));
    }

    public EntityTags(EntityTag ... value) {
        this.string = StringUtils.join((Object[])value, (String)", ");
        this.value = (EntityTag[])CollectionUtils.copyOf((Object[])value);
    }

    public EntityTags(String value) {
        this.string = value;
        this.value = EntityTags.parse(value);
    }

    public EntityTag[] toArray() {
        return (EntityTag[])CollectionUtils.copyOf((Object[])this.value);
    }

    public List<EntityTag> toList() {
        return CollectionUtils.u((List)CollectionUtils.l((Object[])this.value));
    }

    public String toString() {
        return this.string;
    }

    private static EntityTag[] parse(String value) {
        if (value == null) {
            return null;
        }
        String[] s = StringUtils.splita((String)value);
        EntityTag[] v = new EntityTag[s.length];
        for (int i = 0; i < s.length; ++i) {
            v[i] = EntityTag.of(s[i]);
        }
        return v;
    }
}

