/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.juneau.commons.lang.ValueListener;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class Value<T> {
    private T t;
    private ValueListener<T> listener;

    public static <T> Value<T> empty() {
        return new Value<Object>(null);
    }

    public static boolean isType(Type t) {
        Class t3;
        ParameterizedType t2;
        return t instanceof ParameterizedType && (t2 = (ParameterizedType)t).getRawType() == Value.class || t instanceof Class && Value.class.isAssignableFrom(t3 = (Class)t);
    }

    public static <T> Value<T> of(T object) {
        return new Value<T>(object);
    }

    public static Type getParameterType(Type t) {
        Class t3;
        if (t instanceof ParameterizedType) {
            Type[] ta;
            ParameterizedType t2 = (ParameterizedType)t;
            if (t2.getRawType() == Value.class && (ta = t2.getActualTypeArguments()).length > 0) {
                return ta[0];
            }
        } else if (t instanceof Class && Value.class.isAssignableFrom(t3 = (Class)t)) {
            return ClassInfo.of(t3).getParameterType(0, Value.class);
        }
        return null;
    }

    public static Type unwrap(Type t) {
        Type x = Value.getParameterType(t);
        return Utils.nn(x) ? x : t;
    }

    public Value() {
    }

    public Value(T t) {
        this.set(t);
    }

    public boolean equals(Object obj) {
        Value obj2;
        return obj instanceof Value && Utils.eq(this, obj2 = (Value)obj, (x, y) -> Utils.eq(x.t, y.t));
    }

    public Value<T> filter(Predicate<? super T> predicate) {
        AssertionUtils.assertArgNotNull("predicate", predicate);
        if (this.t == null) {
            return Value.empty();
        }
        return predicate.test(this.t) ? this : Value.empty();
    }

    public <T2> Value<T2> flatMap(Function<? super T, ? extends Value<? extends T2>> mapper) {
        Value<T2> result;
        AssertionUtils.assertArgNotNull("mapper", mapper);
        if (this.t == null) {
            return Value.empty();
        }
        Value<T2> cast = result = mapper.apply(this.t);
        return cast;
    }

    public T get() {
        return this.t;
    }

    public T getAndSet(T t) {
        T t2 = this.t;
        this.set(t);
        return t2;
    }

    public T getAndUnset() {
        T t2 = this.t;
        this.t = null;
        return t2;
    }

    public int hashCode() {
        return this.t == null ? 0 : this.t.hashCode();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (Utils.nn(this.t)) {
            consumer.accept(this.t);
        }
    }

    public boolean is(T other) {
        return Utils.eq(this.t, other);
    }

    public boolean isEmpty() {
        return this.t == null;
    }

    public boolean isPresent() {
        return Utils.nn(this.get());
    }

    public Value<T> listener(ValueListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public <T2> Value<T2> map(Function<? super T, T2> mapper) {
        AssertionUtils.assertArgNotNull("mapper", mapper);
        if (Utils.nn(this.t)) {
            return Value.of(mapper.apply(this.t));
        }
        return Value.empty();
    }

    public T orElse(T def) {
        return this.t == null ? def : this.t;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return Utils.nn(this.t) ? this.t : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (Utils.nn(this.t)) {
            return this.t;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Value<T> set(T t) {
        this.t = t;
        if (Utils.nn(this.listener)) {
            this.listener.onSet(t);
        }
        return this;
    }

    public Value<T> setIf(boolean condition, T t) {
        if (condition) {
            this.set(t);
        }
        return this;
    }

    public Value<T> setIfEmpty(T t) {
        if (this.isEmpty()) {
            this.set(t);
        }
        return this;
    }

    public String toString() {
        return "Value(" + String.valueOf(this.t) + ")";
    }

    public Value<T> update(Function<T, T> updater) {
        if (Utils.nn(this.t)) {
            this.set(updater.apply(this.t));
        }
        return this;
    }
}

