/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class ByteValue
extends Value<Byte> {
    public static ByteValue create() {
        return ByteValue.of((byte)0);
    }

    public static ByteValue of(Byte value) {
        return new ByteValue(value);
    }

    public ByteValue() {
        super((byte)0);
    }

    public ByteValue(Byte value) {
        super(value == null ? (byte)0 : value);
    }

    public ByteValue add(Byte x) {
        this.set((byte)((Byte)this.get() + (x == null ? (byte)0 : x)));
        return this;
    }

    public Byte addAndGet(Byte x) {
        this.set((byte)((Byte)this.get() + (x == null ? (byte)0 : x)));
        return (Byte)this.get();
    }

    public ByteValue decrement() {
        this.set((byte)((Byte)this.get() - 1));
        return this;
    }

    public Byte decrementAndGet() {
        this.set((byte)((Byte)this.get() - 1));
        return (Byte)this.get();
    }

    public ByteValue increment() {
        this.set((byte)((Byte)this.get() + 1));
        return this;
    }

    public Byte incrementAndGet() {
        this.set((byte)((Byte)this.get() + 1));
        return (Byte)this.get();
    }

    @Override
    public boolean is(Byte value) {
        return Utils.eq((Byte)this.get(), value);
    }

    public boolean isAny(Byte ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        Byte current = (Byte)this.get();
        for (Byte value : values) {
            if (!Utils.eq(current, value)) continue;
            return true;
        }
        return false;
    }
}

