/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.util.List;
import java.util.Map;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.objecttools.PatternException;

public class SearchArgs {
    private final Map<String, String> search = CollectionUtils.map();

    public static SearchArgs create(List<String> args) {
        if (args == null) {
            return null;
        }
        return new SearchArgs(args);
    }

    public static SearchArgs create(String args) {
        if (args == null) {
            return null;
        }
        return new SearchArgs(args);
    }

    public SearchArgs(List<String> searchArgs) {
        searchArgs.forEach(s -> {
            int i = StringUtils.indexOf(s, '=', '>', '<');
            if (i == -1) {
                throw new PatternException("Invalid search terms: ''{0}''", searchArgs);
            }
            char c = s.charAt(i);
            this.append(s.substring(0, i).trim(), s.substring(c == '=' ? i + 1 : i).trim());
        });
    }

    public SearchArgs(String searchArgs) {
        this(CollectionUtils.l(StringUtils.splita(searchArgs)));
    }

    public SearchArgs append(String column, String searchTerm) {
        this.search.put(column, searchTerm);
        return this;
    }

    public Map<String, String> getSearch() {
        return this.search;
    }
}

