/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.jsonschema;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.bean.jsonschema.JsonSchemaArray;
import org.apache.juneau.bean.jsonschema.JsonSchemaMap;
import org.apache.juneau.bean.jsonschema.JsonSchemaProperty;
import org.apache.juneau.bean.jsonschema.JsonType;
import org.apache.juneau.bean.jsonschema.JsonTypeArray;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;

@Bean(typeName="schema")
public class JsonSchema {
    private String name;
    private URI idUri;
    private URI id;
    private URI schemaVersion;
    private String title;
    private String description;
    private JsonType typeJsonType;
    private JsonTypeArray typeJsonTypeArray;
    private Map<String, JsonSchema> definitions;
    private Map<String, JsonSchema> defs;
    private Map<String, JsonSchema> properties;
    private Map<String, JsonSchema> patternProperties;
    private Map<String, JsonSchema> dependencies;
    private Map<String, JsonSchema> dependentSchemas;
    private Map<String, List<String>> dependentRequired;
    private JsonSchema itemsSchema;
    private JsonSchemaArray itemsSchemaArray;
    private JsonSchemaArray prefixItems;
    private Number multipleOf;
    private Number maximum;
    private Number exclusiveMaximum;
    private Number minimum;
    private Number exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Boolean additionalItemsBoolean;
    private JsonSchemaArray additionalItemsSchemaArray;
    private JsonSchema unevaluatedItems;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private List<String> required;
    private Boolean additionalPropertiesBoolean;
    private JsonSchema additionalPropertiesSchema;
    private JsonSchema unevaluatedProperties;
    private List<Object> enum_;
    private Object const_;
    private List<Object> examples;
    private List<JsonSchema> allOf;
    private List<JsonSchema> anyOf;
    private List<JsonSchema> oneOf;
    private JsonSchema not;
    private JsonSchema if_;
    private JsonSchema then_;
    private JsonSchema else_;
    private Boolean readOnly;
    private Boolean writeOnly;
    private String contentMediaType;
    private String contentEncoding;
    private URI ref;
    private JsonSchemaMap schemaMap;
    private JsonSchema master = this;

    public JsonSchema addAdditionalItems(JsonSchema ... additionalItems) {
        if (this.additionalItemsSchemaArray == null) {
            this.additionalItemsSchemaArray = new JsonSchemaArray();
        }
        this.additionalItemsSchemaArray.addAll(additionalItems);
        this.setMasterOn(additionalItems);
        return this;
    }

    public JsonSchema addAllOf(JsonSchema ... allOf) {
        this.setMasterOn(allOf);
        this.allOf = CollectionUtils.addAll(this.allOf, allOf);
        return this;
    }

    public JsonSchema addAnyOf(JsonSchema ... anyOf) {
        if (this.anyOf == null) {
            this.anyOf = new LinkedList<JsonSchema>();
        }
        this.setMasterOn(anyOf);
        for (JsonSchema s : anyOf) {
            this.anyOf.add(s);
        }
        return this;
    }

    public JsonSchema addDef(String name, JsonSchema def) {
        if (this.defs == null) {
            this.defs = CollectionUtils.map();
        }
        this.defs.put(name, def);
        this.setMasterOn(def);
        return this;
    }

    public JsonSchema addDefinition(String name, JsonSchema definition) {
        if (this.definitions == null) {
            this.definitions = CollectionUtils.map();
        }
        this.definitions.put(name, definition);
        this.setMasterOn(definition);
        return this;
    }

    public JsonSchema addDependency(String name, JsonSchema dependency) {
        if (this.dependencies == null) {
            this.dependencies = CollectionUtils.map();
        }
        this.dependencies.put(name, dependency);
        this.setMasterOn(dependency);
        return this;
    }

    public JsonSchema addDependentRequired(String name, List<String> required) {
        if (this.dependentRequired == null) {
            this.dependentRequired = CollectionUtils.map();
        }
        this.dependentRequired.put(name, required);
        return this;
    }

    public JsonSchema addDependentSchema(String name, JsonSchema schema) {
        if (this.dependentSchemas == null) {
            this.dependentSchemas = CollectionUtils.map();
        }
        this.dependentSchemas.put(name, schema);
        this.setMasterOn(schema);
        return this;
    }

    public JsonSchema addEnum(Object ... enum_) {
        if (this.enum_ == null) {
            this.enum_ = new LinkedList<Object>();
        }
        for (Object e : enum_) {
            this.enum_.add(e);
        }
        return this;
    }

    public JsonSchema addExamples(Object ... examples) {
        if (this.examples == null) {
            this.examples = new LinkedList<Object>();
        }
        for (Object e : examples) {
            this.examples.add(e);
        }
        return this;
    }

    public JsonSchema addItems(JsonSchema ... items) {
        if (this.itemsSchemaArray == null) {
            this.itemsSchemaArray = new JsonSchemaArray();
        }
        this.itemsSchemaArray.addAll(items);
        this.setMasterOn(items);
        return this;
    }

    public JsonSchema addOneOf(JsonSchema ... oneOf) {
        if (this.oneOf == null) {
            this.oneOf = new LinkedList<JsonSchema>();
        }
        this.setMasterOn(oneOf);
        for (JsonSchema s : oneOf) {
            this.oneOf.add(s);
        }
        return this;
    }

    public JsonSchema addPatternProperties(JsonSchemaProperty ... properties) {
        if (this.patternProperties == null) {
            this.patternProperties = CollectionUtils.map();
        }
        for (JsonSchemaProperty p : properties) {
            if (p.getName() == null) {
                throw ThrowableUtils.bex(JsonSchema.class, "Invalid property passed to JsonSchema.addProperties().  Property name was null.", new Object[0]);
            }
            this.setMasterOn(p);
            this.patternProperties.put(p.getName(), p);
        }
        return this;
    }

    public JsonSchema addPrefixItems(JsonSchema ... prefixItems) {
        if (this.prefixItems == null) {
            this.prefixItems = new JsonSchemaArray();
        }
        this.prefixItems.addAll(prefixItems);
        this.setMasterOn(prefixItems);
        return this;
    }

    public JsonSchema addProperties(JsonSchema ... properties) {
        if (this.properties == null) {
            this.properties = CollectionUtils.map();
        }
        for (JsonSchema p : properties) {
            if (p.getName() == null) {
                throw ThrowableUtils.bex(JsonSchema.class, "Invalid property passed to JsonSchema.addProperties().  Property name was null.", new Object[0]);
            }
            this.setMasterOn(p);
            this.properties.put(p.getName(), p);
        }
        return this;
    }

    public JsonSchema addRequired(JsonSchemaProperty ... properties) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (JsonSchemaProperty p : properties) {
            this.required.add(p.getName());
        }
        return this;
    }

    public JsonSchema addRequired(List<String> required) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        required.forEach(x -> this.required.add((String)x));
        return this;
    }

    public JsonSchema addRequired(String ... required) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (String r : required) {
            this.required.add(r);
        }
        return this;
    }

    public JsonSchema addTypes(JsonType ... types) {
        if (this.typeJsonTypeArray == null) {
            this.typeJsonTypeArray = new JsonTypeArray();
        }
        this.typeJsonTypeArray.addAll(types);
        return this;
    }

    @Swap(value=BooleanOrSchemaArraySwap.class)
    public Object getAdditionalItems() {
        if (Utils.nn(this.additionalItemsBoolean)) {
            return this.additionalItemsBoolean;
        }
        return this.additionalItemsSchemaArray;
    }

    @BeanIgnore
    public Boolean getAdditionalItemsAsBoolean() {
        return this.additionalItemsBoolean;
    }

    @BeanIgnore
    public List<JsonSchema> getAdditionalItemsAsSchemaArray() {
        return this.additionalItemsSchemaArray;
    }

    @Swap(value=BooleanOrSchemaSwap.class)
    public Object getAdditionalProperties() {
        if (Utils.nn(this.additionalPropertiesBoolean)) {
            return this.additionalItemsBoolean;
        }
        return this.additionalPropertiesSchema;
    }

    @BeanIgnore
    public Boolean getAdditionalPropertiesAsBoolean() {
        return this.additionalPropertiesBoolean;
    }

    @BeanIgnore
    public JsonSchema getAdditionalPropertiesAsSchema() {
        return this.additionalPropertiesSchema;
    }

    public List<JsonSchema> getAllOf() {
        return this.allOf;
    }

    public List<JsonSchema> getAnyOf() {
        return this.anyOf;
    }

    public Object getConst() {
        return this.const_;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentMediaType() {
        return this.contentMediaType;
    }

    public Map<String, JsonSchema> getDefinitions() {
        return Utils.nn(this.definitions) ? this.definitions : this.defs;
    }

    @Beanp(value="$defs")
    public Map<String, JsonSchema> getDefs() {
        return this.defs;
    }

    public Map<String, JsonSchema> getDependencies() {
        return this.dependencies;
    }

    public Map<String, List<String>> getDependentRequired() {
        return this.dependentRequired;
    }

    public Map<String, JsonSchema> getDependentSchemas() {
        return this.dependentSchemas;
    }

    public String getDescription() {
        return this.description;
    }

    @Beanp(value="else")
    public JsonSchema getElse() {
        return this.else_;
    }

    public List<Object> getEnum() {
        return this.enum_;
    }

    public List<Object> getExamples() {
        return this.examples;
    }

    public Number getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Number getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Deprecated
    public URI getId() {
        return Utils.nn(this.id) ? this.id : this.idUri;
    }

    @Beanp(value="$id")
    public URI getIdUri() {
        return this.idUri;
    }

    @Beanp(value="if")
    public JsonSchema getIf() {
        return this.if_;
    }

    @Swap(value=JsonSchemaOrSchemaArraySwap.class)
    public Object getItems() {
        if (Utils.nn(this.itemsSchema)) {
            return this.itemsSchema;
        }
        return this.itemsSchemaArray;
    }

    @BeanIgnore
    public JsonSchema getItemsAsSchema() {
        return this.itemsSchema;
    }

    @BeanIgnore
    public JsonSchemaArray getItemsAsSchemaArray() {
        return this.itemsSchemaArray;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    @BeanIgnore
    public String getName() {
        return this.name;
    }

    public JsonSchema getNot() {
        return this.not;
    }

    public List<JsonSchema> getOneOf() {
        return this.oneOf;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Map<String, JsonSchema> getPatternProperties() {
        return this.patternProperties;
    }

    public JsonSchemaArray getPrefixItems() {
        return this.prefixItems;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    public JsonSchema getProperty(String name) {
        return this.getProperty(name, false);
    }

    public JsonSchema getProperty(String name, boolean resolve) {
        if (this.properties == null) {
            return null;
        }
        JsonSchema s = this.properties.get(name);
        if (s == null) {
            return null;
        }
        if (resolve) {
            s = s.resolve();
        }
        return s;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Beanp(value="$ref")
    public URI getRef() {
        return this.ref;
    }

    public List<String> getRequired() {
        return this.required;
    }

    @Beanp(value="$schema")
    public URI getSchemaVersionUri() {
        return this.schemaVersion;
    }

    @Beanp(value="then")
    public JsonSchema getThen() {
        return this.then_;
    }

    public String getTitle() {
        return this.title;
    }

    @Swap(value=JsonTypeOrJsonTypeArraySwap.class)
    public Object getType() {
        if (Utils.nn((Object)this.typeJsonType)) {
            return this.typeJsonType;
        }
        return this.typeJsonTypeArray;
    }

    @BeanIgnore
    public JsonType getTypeAsJsonType() {
        return this.typeJsonType;
    }

    @BeanIgnore
    public JsonTypeArray getTypeAsJsonTypeArray() {
        return this.typeJsonTypeArray;
    }

    public JsonSchema getUnevaluatedItems() {
        return this.unevaluatedItems;
    }

    public JsonSchema getUnevaluatedProperties() {
        return this.unevaluatedProperties;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public JsonSchema resolve() {
        if (this.ref == null || this.master.schemaMap == null) {
            return this;
        }
        return this.master.schemaMap.get(this.ref);
    }

    public JsonSchema setAdditionalItems(Object additionalItems) {
        this.additionalItemsBoolean = null;
        this.additionalItemsSchemaArray = null;
        if (Utils.nn(additionalItems)) {
            if (additionalItems instanceof Boolean) {
                Boolean additionalItems2;
                this.additionalItemsBoolean = additionalItems2 = (Boolean)additionalItems;
            } else if (additionalItems instanceof JsonSchemaArray) {
                JsonSchemaArray additionalItems2;
                this.additionalItemsSchemaArray = additionalItems2 = (JsonSchemaArray)additionalItems;
                this.setMasterOn(this.additionalItemsSchemaArray);
            } else {
                throw ThrowableUtils.bex(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Boolean, JsonSchemaArray", Utils.cn(additionalItems));
            }
        }
        return this;
    }

    @Beanp(dictionary={JsonSchema.class})
    public JsonSchema setAdditionalProperties(Object additionalProperties) {
        this.additionalPropertiesBoolean = null;
        this.additionalPropertiesSchema = null;
        if (Utils.nn(additionalProperties)) {
            if (additionalProperties instanceof Boolean) {
                Boolean additionalProperties2;
                this.additionalPropertiesBoolean = additionalProperties2 = (Boolean)additionalProperties;
            } else if (additionalProperties instanceof JsonSchema) {
                JsonSchema additionalProperties2;
                this.additionalPropertiesSchema = additionalProperties2 = (JsonSchema)additionalProperties;
                this.setMasterOn(this.additionalPropertiesSchema);
            } else {
                throw ThrowableUtils.bex(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Boolean, JsonSchema", Utils.cn(additionalProperties));
            }
        }
        return this;
    }

    public JsonSchema setAllOf(List<JsonSchema> allOf) {
        this.allOf = allOf;
        this.setMasterOn(allOf);
        return this;
    }

    public JsonSchema setAnyOf(List<JsonSchema> anyOf) {
        this.anyOf = anyOf;
        this.setMasterOn(anyOf);
        return this;
    }

    public JsonSchema setConst(Object const_) {
        this.const_ = const_;
        return this;
    }

    public JsonSchema setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public JsonSchema setContentMediaType(String contentMediaType) {
        this.contentMediaType = contentMediaType;
        return this;
    }

    public JsonSchema setDefinitions(Map<String, JsonSchema> definitions) {
        this.definitions = definitions;
        if (Utils.nn(definitions)) {
            this.setMasterOn(definitions.values());
        }
        return this;
    }

    @Beanp(value="$defs")
    public JsonSchema setDefs(Map<String, JsonSchema> defs) {
        this.defs = defs;
        if (Utils.nn(defs)) {
            this.setMasterOn(defs.values());
        }
        return this;
    }

    public JsonSchema setDependencies(Map<String, JsonSchema> dependencies) {
        this.dependencies = dependencies;
        if (Utils.nn(dependencies)) {
            this.setMasterOn(dependencies.values());
        }
        return this;
    }

    public JsonSchema setDependentRequired(Map<String, List<String>> dependentRequired) {
        this.dependentRequired = dependentRequired;
        return this;
    }

    public JsonSchema setDependentSchemas(Map<String, JsonSchema> dependentSchemas) {
        this.dependentSchemas = dependentSchemas;
        if (Utils.nn(dependentSchemas)) {
            this.setMasterOn(dependentSchemas.values());
        }
        return this;
    }

    public JsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    @Beanp(value="else")
    public JsonSchema setElse(JsonSchema else_) {
        this.else_ = else_;
        this.setMasterOn(else_);
        return this;
    }

    public JsonSchema setEnum(List<Object> enum_) {
        this.enum_ = enum_;
        return this;
    }

    public JsonSchema setExamples(List<Object> examples) {
        this.examples = examples;
        return this;
    }

    public JsonSchema setExclusiveMaximum(Number exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public JsonSchema setExclusiveMinimum(Number exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    @Deprecated
    public JsonSchema setId(Object id) {
        this.id = StringUtils.toUri(id);
        return this;
    }

    @Beanp(value="$id")
    public JsonSchema setIdUri(Object idUri) {
        this.idUri = StringUtils.toUri(idUri);
        return this;
    }

    @Beanp(value="if")
    public JsonSchema setIf(JsonSchema if_) {
        this.if_ = if_;
        this.setMasterOn(if_);
        return this;
    }

    public JsonSchema setItems(Object items) {
        this.itemsSchema = null;
        this.itemsSchemaArray = null;
        if (Utils.nn(items)) {
            if (items instanceof JsonSchema) {
                JsonSchema items2;
                this.itemsSchema = items2 = (JsonSchema)items;
                this.setMasterOn(this.itemsSchema);
            } else if (items instanceof JsonSchemaArray) {
                JsonSchemaArray items2;
                this.itemsSchemaArray = items2 = (JsonSchemaArray)items;
                this.setMasterOn(this.itemsSchemaArray);
            } else {
                throw ThrowableUtils.bex(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  JsonSchema, JsonSchemaArray", Utils.cn(items));
            }
        }
        return this;
    }

    public JsonSchema setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public JsonSchema setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public JsonSchema setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public JsonSchema setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public JsonSchema setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public JsonSchema setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public JsonSchema setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public JsonSchema setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public JsonSchema setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    @BeanIgnore
    public JsonSchema setName(String name) {
        this.name = name;
        return this;
    }

    public JsonSchema setNot(JsonSchema not) {
        this.not = not;
        this.setMasterOn(not);
        return this;
    }

    public JsonSchema setOneOf(List<JsonSchema> oneOf) {
        this.oneOf = oneOf;
        this.setMasterOn(oneOf);
        return this;
    }

    public JsonSchema setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public JsonSchema setPatternProperties(Map<String, JsonSchema> patternProperties) {
        this.patternProperties = patternProperties;
        if (Utils.nn(patternProperties)) {
            patternProperties.entrySet().forEach(x -> {
                JsonSchema s = (JsonSchema)x.getValue();
                this.setMasterOn(s);
                s.setName((String)x.getKey());
            });
        }
        return this;
    }

    public JsonSchema setPrefixItems(JsonSchemaArray prefixItems) {
        this.prefixItems = prefixItems;
        this.setMasterOn(prefixItems);
        return this;
    }

    public JsonSchema setProperties(Map<String, JsonSchema> properties) {
        this.properties = properties;
        if (Utils.nn(properties)) {
            properties.entrySet().forEach(x -> {
                JsonSchema value = (JsonSchema)x.getValue();
                this.setMasterOn(value);
                value.setName((String)x.getKey());
            });
        }
        return this;
    }

    public JsonSchema setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Beanp(value="$ref")
    public JsonSchema setRef(Object ref) {
        this.ref = StringUtils.toUri(ref);
        return this;
    }

    public JsonSchema setRequired(List<String> required) {
        this.required = required;
        return this;
    }

    @BeanIgnore
    public JsonSchema setSchemaMap(JsonSchemaMap schemaMap) {
        this.schemaMap = schemaMap;
        return this;
    }

    @Beanp(value="$schema")
    public JsonSchema setSchemaVersionUri(Object schemaVersion) {
        this.schemaVersion = StringUtils.toUri(schemaVersion);
        return this;
    }

    @Beanp(value="then")
    public JsonSchema setThen(JsonSchema then_) {
        this.then_ = then_;
        this.setMasterOn(then_);
        return this;
    }

    public JsonSchema setTitle(String title) {
        this.title = title;
        return this;
    }

    public JsonSchema setType(Object type) {
        this.typeJsonType = null;
        this.typeJsonTypeArray = null;
        if (Utils.nn(type)) {
            if (type instanceof JsonType) {
                JsonType type2;
                this.typeJsonType = type2 = (JsonType)((Object)type);
            } else if (type instanceof JsonTypeArray) {
                JsonTypeArray type2;
                this.typeJsonTypeArray = type2 = (JsonTypeArray)type;
            } else {
                throw ThrowableUtils.bex(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  SimpleType, SimpleTypeArray", Utils.cn(type));
            }
        }
        return this;
    }

    public JsonSchema setUnevaluatedItems(JsonSchema unevaluatedItems) {
        this.unevaluatedItems = unevaluatedItems;
        this.setMasterOn(unevaluatedItems);
        return this;
    }

    public JsonSchema setUnevaluatedProperties(JsonSchema unevaluatedProperties) {
        this.unevaluatedProperties = unevaluatedProperties;
        this.setMasterOn(unevaluatedProperties);
        return this;
    }

    public JsonSchema setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public JsonSchema setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public String toString() {
        return JsonSerializer.DEFAULT_SORTED.toString(this);
    }

    private void setMasterOn(Collection<JsonSchema> ss) {
        if (Utils.nn(ss)) {
            ss.forEach(this::setMasterOn);
        }
    }

    private void setMasterOn(JsonSchema s) {
        if (Utils.nn(s)) {
            s.setMaster(this);
        }
    }

    private void setMasterOn(JsonSchema[] ss) {
        if (Utils.nn(ss)) {
            for (JsonSchema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    private void setMasterOn(JsonSchemaArray ss) {
        if (Utils.nn(ss)) {
            ss.forEach(this::setMasterOn);
        }
    }

    protected void setMaster(JsonSchema master) {
        this.master = master;
        if (Utils.nn(this.definitions)) {
            this.definitions.values().forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.defs)) {
            this.defs.values().forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.properties)) {
            this.properties.values().forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.patternProperties)) {
            this.patternProperties.values().forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.dependencies)) {
            this.dependencies.values().forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.dependentSchemas)) {
            this.dependentSchemas.values().forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.itemsSchema)) {
            this.itemsSchema.setMaster(master);
        }
        if (Utils.nn(this.itemsSchemaArray)) {
            this.itemsSchemaArray.forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.prefixItems)) {
            this.prefixItems.forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.additionalItemsSchemaArray)) {
            this.additionalItemsSchemaArray.forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.unevaluatedItems)) {
            this.unevaluatedItems.setMaster(master);
        }
        if (Utils.nn(this.additionalPropertiesSchema)) {
            this.additionalPropertiesSchema.setMaster(master);
        }
        if (Utils.nn(this.unevaluatedProperties)) {
            this.unevaluatedProperties.setMaster(master);
        }
        if (Utils.nn(this.allOf)) {
            this.allOf.forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.anyOf)) {
            this.anyOf.forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.oneOf)) {
            this.oneOf.forEach(x -> x.setMaster(master));
        }
        if (Utils.nn(this.not)) {
            this.not.setMaster(master);
        }
        if (Utils.nn(this.if_)) {
            this.if_.setMaster(master);
        }
        if (Utils.nn(this.then_)) {
            this.then_.setMaster(master);
        }
        if (Utils.nn(this.else_)) {
            this.else_.setMaster(master);
        }
    }

    public static class JsonTypeOrJsonTypeArraySwap
    extends ObjectSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Collection ? session.getClassMeta(JsonTypeArray.class) : session.getClassMeta(JsonType.class);
            return session.convertToType(o, cm);
        }
    }

    public static class JsonSchemaOrSchemaArraySwap
    extends ObjectSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Collection ? session.getClassMeta(JsonSchemaArray.class) : session.getClassMeta(JsonSchema.class);
            return session.convertToType(o, cm);
        }
    }

    public static class BooleanOrSchemaSwap
    extends ObjectSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Boolean ? session.getClassMeta(Boolean.class) : session.getClassMeta(JsonSchema.class);
            return session.convertToType(o, cm);
        }
    }

    public static class BooleanOrSchemaArraySwap
    extends ObjectSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Serializable> cm = o instanceof Collection ? session.getClassMeta(JsonSchemaArray.class) : session.getClassMeta(Boolean.class);
            return session.convertToType(o, cm);
        }
    }
}

