/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.progress;

import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.system.progress.ProgressMonitor;

public class ProgressMonitorBasic
implements ProgressMonitor {
    private Timer timer = new Timer();
    private long timeInMillis = -1L;
    private long tickCounter = 0L;
    private boolean inSection = false;
    private int sectionCounter = 0;
    private Timer sectionTimer = null;
    private long sectionTimeInMillis = -1L;
    private long sectionTickCounter = 0L;

    @Override
    public void startMessage(String message) {
    }

    @Override
    public void finishMessage(String message) {
    }

    @Override
    public void start() {
        this.timer.startTimer();
    }

    @Override
    public void finish() {
        this.timeInMillis = this.timer.endTimer();
    }

    @Override
    public void startSection() {
        if (this.inSection) {
            throw new IllegalStateException("startSection: Already in section");
        }
        this.inSection = true;
        ++this.sectionCounter;
        this.sectionTimer = new Timer();
        this.sectionTimeInMillis = 0L;
        this.sectionTickCounter = 0L;
    }

    @Override
    public void finishSection() {
        if (!this.inSection) {
            throw new IllegalStateException("finishSection: Not in section");
        }
        this.inSection = false;
        this.sectionTimeInMillis = this.sectionTimer.endTimer();
    }

    @Override
    public void tick() {
        ++this.tickCounter;
        if (this.inSection) {
            ++this.sectionTickCounter;
        }
    }

    @Override
    public long getTicks() {
        return this.tickCounter;
    }

    @Override
    public long getTime() {
        return this.timeInMillis;
    }

    @Override
    public long getSectionTicks() {
        return this.sectionTickCounter;
    }

    @Override
    public long getSectionTime() {
        return this.sectionTimeInMillis;
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public void setLabel(String label) {
    }
}

