/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.RegexEngine;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;

public class E_StrReplace
extends ExprFunctionN {
    private static final String symbol = "replace";
    private final Pattern pattern;

    public E_StrReplace(Expr expr1, Expr expr2, Expr expr3) {
        this(expr1, expr2, expr3, null);
    }

    public E_StrReplace(Expr expr1, Expr expr2, Expr expr3, Expr expr4) {
        super(symbol, expr1, expr2, expr3, expr4);
        Pattern pattern0 = null;
        if (E_StrReplace.isString(expr2) && (expr4 == null || E_StrReplace.isString(expr4))) {
            String flags = null;
            if (expr4 != null && expr4.isConstant() && expr4.getConstant().isString()) {
                flags = expr4.getConstant().getString();
            }
            String patternStr = expr2.getConstant().getString();
            pattern0 = RegexEngine.makePattern("REPLACE", patternStr, flags);
        }
        this.pattern = pattern0;
    }

    private static boolean isString(Expr expr) {
        return expr.isConstant() && expr.getConstant().isString();
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        if (this.pattern != null) {
            return XSDFuncOp.strReplace(args.get(0), this.pattern, args.get(2));
        }
        if (args.size() == 3) {
            return XSDFuncOp.strReplace(args.get(0), args.get(1), args.get(2));
        }
        return XSDFuncOp.strReplace(args.get(0), args.get(1), args.get(2), args.get(3));
    }

    @Override
    public Expr copy(ExprList newArgs) {
        if (newArgs.size() == 3) {
            return new E_StrReplace(newArgs.get(0), newArgs.get(1), newArgs.get(2), null);
        }
        return new E_StrReplace(newArgs.get(0), newArgs.get(1), newArgs.get(2), newArgs.get(3));
    }
}

