/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.UnsupportedPolymorphismException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntSWRL;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.SWRL;

public class OntSWRLImpl
extends OntObjectImpl
implements OntSWRL {
    public OntSWRLImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntSWRL.Builtin fetchBuiltinEntity(OntGraphModelImpl model, String uri) {
        OntSWRL.Builtin res = model.findNodeAs(NodeFactory.createURI((String)OntJenaException.notNull(uri, "Null uri.")), OntSWRL.Builtin.class);
        if (res == null) {
            res = OntSWRLImpl.createBuiltinEntity(model, uri);
        }
        return res;
    }

    public static OntSWRL.Builtin createBuiltinEntity(OntGraphModelImpl model, String uri) {
        return model.createOntObject(OntSWRL.Builtin.class, Objects.requireNonNull(uri));
    }

    public static OntSWRL.Variable createVariable(OntGraphModelImpl model, String uri) {
        return model.createOntObject(OntSWRL.Variable.class, uri);
    }

    public static OntSWRL.Atom.WithBuiltin createBuiltInAtom(OntGraphModelImpl model, Resource predicate, Collection<OntSWRL.DArg> arguments) {
        OntSWRL.Builtin property = OntSWRLImpl.fetchBuiltinEntity(model, predicate.getURI());
        OntObject res = (OntObject)model.createResource(SWRL.BuiltinAtom).addProperty(SWRL.builtin, (RDFNode)property).as(OntObject.class);
        model.createOntList(res, SWRL.arguments, (Resource)null, OntSWRL.DArg.class, Iterators.create(arguments));
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithBuiltin.class);
    }

    public static OntSWRL.Atom.WithClass createClassAtom(OntGraphModelImpl model, OntClass clazz, OntSWRL.IArg arg) {
        OntJenaException.notNull(clazz, "Null class");
        OntJenaException.notNull(arg, "Null i-arg");
        Resource res = model.createResource(SWRL.ClassAtom).addProperty(SWRL.classPredicate, (RDFNode)clazz).addProperty(SWRL.argument1, (RDFNode)arg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithClass.class);
    }

    public static OntSWRL.Atom.WithDataRange createDataRangeAtom(OntGraphModelImpl model, OntDataRange range, OntSWRL.DArg arg) {
        OntJenaException.notNull(range, "Null data range");
        OntJenaException.notNull(arg, "Null d-arg");
        Resource res = model.createResource(SWRL.DataRangeAtom).addProperty(SWRL.dataRange, (RDFNode)range).addProperty(SWRL.argument1, (RDFNode)arg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithDataRange.class);
    }

    public static OntSWRL.Atom.WithDataProperty createDataPropertyAtom(OntGraphModelImpl model, OntDataProperty dataProperty, OntSWRL.IArg firstArg, OntSWRL.DArg secondArg) {
        OntJenaException.notNull(dataProperty, "Null data property");
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second d-arg");
        Resource res = model.createResource(SWRL.DatavaluedPropertyAtom).addProperty(SWRL.propertyPredicate, (RDFNode)dataProperty).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithDataProperty.class);
    }

    public static OntSWRL.Atom.WithObjectProperty createObjectPropertyAtom(OntGraphModelImpl model, OntObjectProperty objectProperty, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(objectProperty, "Null object property");
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.IndividualPropertyAtom).addProperty(SWRL.propertyPredicate, (RDFNode)objectProperty).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithObjectProperty.class);
    }

    public static OntSWRL.Atom.WithDifferentIndividuals createDifferentIndividualsAtom(OntGraphModelImpl model, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.DifferentIndividualsAtom).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        model.fetchOntEntity(OntObjectProperty.Named.class, OWL2.differentFrom.getURI());
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithDifferentIndividuals.class);
    }

    public static OntSWRL.Atom.WithSameIndividuals createSameIndividualsAtom(OntGraphModelImpl model, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.SameIndividualAtom).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        model.fetchOntEntity(OntObjectProperty.Named.class, OWL2.sameAs.getURI());
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithSameIndividuals.class);
    }

    public static OntSWRL.Imp createImp(OntGraphModelImpl model, Collection<OntSWRL.Atom<? extends OntObject>> head, Collection<OntSWRL.Atom<? extends OntObject>> body) {
        OntJenaException.notNull(head, "Null head");
        OntJenaException.notNull(body, "Null body");
        OntObject res = (OntObject)model.createResource(SWRL.Imp).as(OntObject.class);
        model.createOntList(res, SWRL.head, SWRL.AtomList, OntSWRL.Atom.class, Iterators.create(head));
        model.createOntList(res, SWRL.body, SWRL.AtomList, OntSWRL.Atom.class, Iterators.create(body));
        return model.getNodeAs(res.asNode(), OntSWRL.Imp.class);
    }

    public static class ImpImpl
    extends OntSWRLImpl
    implements OntSWRL.Imp {
        public ImpImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public OntListImpl<OntSWRL.Atom> getHeadList() {
            return this.getList(SWRL.head);
        }

        public OntListImpl<OntSWRL.Atom> getBodyList() {
            return this.getList(SWRL.body);
        }

        protected OntListImpl<OntSWRL.Atom> getList(Property predicate) {
            RDFList list = this.getRequiredObject(predicate, RDFList.class);
            return this.getModel().asOntList(list, this, predicate, false, SWRL.AtomList, OntSWRL.Atom.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), ((OntListImpl)this.getHeadList()).listContent(), ((OntListImpl)this.getBodyList()).listContent());
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return ImpImpl.getRequiredRootStatement(this, SWRL.Imp);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Imp.class;
        }
    }

    public static class SameIndividualsAtomImpl
    extends IndividualsAtomImpl
    implements OntSWRL.Atom.WithSameIndividuals {
        public SameIndividualsAtomImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.sameAs);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.SameIndividualAtom;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithSameIndividuals.class;
        }
    }

    public static class DifferentIndividualsAtomImpl
    extends IndividualsAtomImpl
    implements OntSWRL.Atom.WithDifferentIndividuals {
        public DifferentIndividualsAtomImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.differentFrom);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DifferentIndividualsAtom;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithDifferentIndividuals.class;
        }
    }

    public static abstract class IndividualsAtomImpl
    extends BinaryImpl<OntObjectProperty.Named, OntSWRL.IArg, OntSWRL.IArg> {
        public IndividualsAtomImpl(Node n, EnhGraph m, Property predicate) {
            super(n, m, predicate, OntObjectProperty.Named.class, OntSWRL.IArg.class, OntSWRL.IArg.class);
        }

        @Override
        public OntObjectProperty.Named getPredicate() {
            return (OntObjectProperty.Named)this.getModel().fetchOntEntity(OntObjectProperty.Named.class, this.predicate.getURI());
        }

        @Override
        protected ExtendedIterator<OntStatement> listPredicateSpec() {
            OntStatement s = this.getPredicate().getMainStatement();
            return s == null ? NullIterator.instance() : Iterators.of(s);
        }
    }

    public static class ObjectPropertyAtomImpl
    extends PropertyAtomImpl<OntObjectProperty, OntSWRL.IArg>
    implements OntSWRL.Atom.WithObjectProperty {
        public ObjectPropertyAtomImpl(Node n, EnhGraph m) {
            super(n, m, OntObjectProperty.class, OntSWRL.IArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.IndividualPropertyAtom;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithObjectProperty.class;
        }
    }

    public static class DataPropertyAtomImpl
    extends PropertyAtomImpl<OntDataProperty, OntSWRL.DArg>
    implements OntSWRL.Atom.WithDataProperty {
        public DataPropertyAtomImpl(Node n, EnhGraph m) {
            super(n, m, OntDataProperty.class, OntSWRL.DArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DatavaluedPropertyAtom;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithDataProperty.class;
        }
    }

    public static abstract class PropertyAtomImpl<P extends OntProperty, A extends OntSWRL.Arg>
    extends BinaryImpl<P, OntSWRL.IArg, A> {
        PropertyAtomImpl(Node n, EnhGraph m, Class<P> objectType, Class<A> secondArgType) {
            super(n, m, SWRL.propertyPredicate, objectType, OntSWRL.IArg.class, secondArgType);
        }
    }

    public static abstract class BinaryImpl<O extends OntObject, F extends OntSWRL.Arg, S extends OntSWRL.Arg>
    extends AtomImpl<O>
    implements OntSWRL.Atom.Binary<O, F, S> {
        protected final Property predicate;
        private final Class<O> objectType;
        private final Class<F> firstArgType;
        private final Class<S> secondArgType;

        BinaryImpl(Node n, EnhGraph m, Property predicate, Class<O> objectType, Class<F> firstArgType, Class<S> secondArgType) {
            super(n, m);
            this.predicate = predicate;
            this.objectType = objectType;
            this.firstArgType = firstArgType;
            this.secondArgType = secondArgType;
        }

        @Override
        public O getPredicate() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectType));
        }

        @Override
        public F getFirstArg() {
            return (F)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument1, this.firstArgType));
        }

        @Override
        public S getSecondArg() {
            return (S)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument2, this.secondArgType));
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listPredicateSpec(), this.listRequired(SWRL.argument1, SWRL.argument2));
        }

        protected ExtendedIterator<OntStatement> listPredicateSpec() {
            return this.listRequired(this.predicate);
        }
    }

    public static class DataRangeAtomImpl
    extends UnaryImpl<OntDataRange, OntSWRL.DArg>
    implements OntSWRL.Atom.WithDataRange {
        public DataRangeAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.dataRange, OntDataRange.class, OntSWRL.DArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DataRangeAtom;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithDataRange.class;
        }
    }

    public static class OntClassAtomImpl
    extends UnaryImpl<OntClass, OntSWRL.IArg>
    implements OntSWRL.Atom.WithClass {
        public OntClassAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.classPredicate, OntClass.class, OntSWRL.IArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.ClassAtom;
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithClass.class;
        }
    }

    public static abstract class UnaryImpl<O extends OntObject, A extends OntSWRL.Arg>
    extends AtomImpl<O>
    implements OntSWRL.Atom.Unary<O, A> {
        private final Property predicate;
        private final Class<O> objectView;
        private final Class<A> argView;

        UnaryImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<A> argView) {
            super(n, m);
            this.predicate = predicate;
            this.objectView = objectView;
            this.argView = argView;
        }

        @Override
        public A getArg() {
            return (A)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument1, this.argView));
        }

        @Override
        public O getPredicate() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectView));
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listRequired(this.predicate, SWRL.argument1));
        }
    }

    public static class BuiltInAtomImpl
    extends AtomImpl<OntSWRL.Builtin>
    implements OntSWRL.Atom.WithBuiltin {
        public BuiltInAtomImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.BuiltinAtom;
        }

        @Override
        public OntSWRL.Builtin getPredicate() {
            return this.getRequiredObject(SWRL.builtin, OntSWRL.Builtin.class);
        }

        public OntListImpl<OntSWRL.DArg> getArgList() {
            return this.getModel().asOntList(this.getRequiredObject(SWRL.arguments, RDFList.class), this, SWRL.arguments, OntSWRL.DArg.class);
        }

        public ExtendedIterator<OntStatement> listPredicateStatements() {
            OntStatement p = this.getRequiredProperty(SWRL.builtin);
            OntStatement b = this.getPredicate().getMainStatement();
            return b == null ? Iterators.of(p) : Iterators.of(new OntStatement[]{p, b});
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listPredicateStatements(), ((OntListImpl)this.getArgList()).listContent());
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Atom.WithBuiltin.class;
        }
    }

    public static abstract class AtomImpl<P extends OntObject>
    extends OntSWRLImpl
    implements OntSWRL.Atom<P> {
        public AtomImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return AtomImpl.getRequiredRootStatement(this, this.getResourceType());
        }

        public abstract Resource getResourceType();
    }

    public static class IArgImpl
    extends OntObjectImpl
    implements OntSWRL.IArg {
        public IArgImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.IArg.class;
        }
    }

    public static class DArgImpl
    extends OntObjectImpl
    implements OntSWRL.DArg {
        public DArgImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.DArg.class;
        }

        public Literal asLiteral() throws UnsupportedPolymorphismException {
            return (Literal)this.as(Literal.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return this.node.isLiteral() ? NullIterator.instance() : ((VariableImpl)this.as(OntSWRL.Variable.class)).listSpec();
        }
    }

    public static class VariableImpl
    extends OntSWRLImpl
    implements OntSWRL.Variable {
        public VariableImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Variable.class;
        }
    }

    public static class BuiltinImpl
    extends OntSWRLImpl
    implements OntSWRL.Builtin {
        public BuiltinImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntSWRL.Builtin.class;
        }
    }
}

