/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class PacketsConfirmedMessage
extends PacketImpl {
    private int commandID;

    public PacketsConfirmedMessage(int commandID) {
        super((byte)22);
        this.commandID = commandID;
    }

    public PacketsConfirmedMessage() {
        super((byte)22);
    }

    public int getCommandID() {
        return this.commandID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.commandID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.commandID = buffer.readInt();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", commandID=" + this.commandID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.commandID;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PacketsConfirmedMessage)) {
            return false;
        }
        PacketsConfirmedMessage other = (PacketsConfirmedMessage)obj;
        return this.commandID == other.commandID;
    }
}

