/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartInteractiveTransactionExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Deprecated
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StartInteractiveTransactionExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String START_INTERACTIVE_TRANSACTION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.3";
    private static final byte TYPE_BASE_DN = -128;
    private static final long serialVersionUID = 4475028061132753546L;
    @Nullable
    private final String baseDN;

    public StartInteractiveTransactionExtendedRequest() {
        super(START_INTERACTIVE_TRANSACTION_REQUEST_OID);
        this.baseDN = null;
    }

    public StartInteractiveTransactionExtendedRequest(@Nullable String baseDN) {
        super(START_INTERACTIVE_TRANSACTION_REQUEST_OID, StartInteractiveTransactionExtendedRequest.encodeValue(baseDN));
        this.baseDN = baseDN;
    }

    public StartInteractiveTransactionExtendedRequest(@Nullable String baseDN, @Nullable Control[] controls) {
        super(START_INTERACTIVE_TRANSACTION_REQUEST_OID, StartInteractiveTransactionExtendedRequest.encodeValue(baseDN), controls);
        this.baseDN = baseDN;
    }

    public StartInteractiveTransactionExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        if (!extendedRequest.hasValue()) {
            this.baseDN = null;
            return;
        }
        String baseDNStr = null;
        try {
            ASN1Element valueElement = ASN1Element.decode(extendedRequest.getValue().getValue());
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
            for (ASN1Element e : valueSequence.elements()) {
                if (e.getType() != -128) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_INT_TXN_REQUEST_INVALID_ELEMENT.get(StaticUtils.toHex(e.getType())));
                }
                baseDNStr = ASN1OctetString.decodeAsOctetString(e).stringValue();
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_INT_TXN_REQUEST_VALUE_NOT_SEQUENCE.get(e.getMessage()), e);
        }
        this.baseDN = baseDNStr;
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable String baseDN) {
        if (baseDN == null) {
            return null;
        }
        ASN1Element[] elements = new ASN1Element[]{new ASN1OctetString(-128, baseDN)};
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getBaseDN() {
        return this.baseDN;
    }

    @Override
    @NotNull
    public StartInteractiveTransactionExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new StartInteractiveTransactionExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public StartInteractiveTransactionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public StartInteractiveTransactionExtendedRequest duplicate(@Nullable Control[] controls) {
        StartInteractiveTransactionExtendedRequest r = new StartInteractiveTransactionExtendedRequest(this.baseDN, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_START_INTERACTIVE_TXN.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("StartInteractiveTransactionExtendedRequest(");
        if (this.baseDN != null) {
            buffer.append("baseDN='");
            buffer.append(this.baseDN);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            if (this.baseDN != null) {
                buffer.append(", ");
            }
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

