/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.MailboxCreationId;
import org.apache.james.jmap.mail.MailboxCreationRequest;
import org.apache.james.jmap.mail.MailboxCreationRequest$;
import org.apache.james.jmap.mail.MailboxCreationResponse;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.method.MailboxCreationParseException;
import org.apache.james.jmap.method.MailboxSetCreatePerformer$;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.utils.quotas.QuotaLoaderWithPreloadedDefaultFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011}t!\u00024h\u0011\u0003\u0011h!\u0002;h\u0011\u0003)\b\"\u0002?\u0002\t\u0003i\bb\u0002@\u0002\u0005\u0004%Ia \u0005\t\u0003\u001b\t\u0001\u0015!\u0003\u0002\u0002\u0019I\u0011qB\u0001\u0011\u0002G\u0005\u0012\u0011\u0003\u0005\b\u0003')a\u0011AA\u000b\r\u0019\t\u00190\u0001!\u0002v\"Q\u00111C\u0004\u0003\u0016\u0004%\t!!\u0006\t\u0015\u0005-sA!E!\u0002\u0013\t9\u0002\u0003\u0006\u0002x\u001e\u0011)\u001a!C\u0001\u0003sD!B!\u0001\b\u0005#\u0005\u000b\u0011BA~\u0011\u0019ax\u0001\"\u0001\u0003\u0004!I\u0011\u0011O\u0004\u0002\u0002\u0013\u0005!1\u0002\u0005\n\u0003s:\u0011\u0013!C\u0001\u0003wB\u0011\"!%\b#\u0003%\tA!\u0005\t\u0013\u0005]u!!A\u0005B\u0005e\u0005\"CAV\u000f\u0005\u0005I\u0011AAW\u0011%\t)lBA\u0001\n\u0003\u0011)\u0002C\u0005\u0002D\u001e\t\t\u0011\"\u0011\u0002F\"I\u00111[\u0004\u0002\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0003?<\u0011\u0011!C!\u0005;A\u0011\"!:\b\u0003\u0003%\t%a:\t\u0013\u0005%x!!A\u0005B\u0005-\b\"CAw\u000f\u0005\u0005I\u0011\tB\u0011\u000f%\u0011)#AA\u0001\u0012\u0003\u00119CB\u0005\u0002t\u0006\t\t\u0011#\u0001\u0003*!1AP\u0007C\u0001\u0005\u0003B\u0011\"!;\u001b\u0003\u0003%)%a;\t\u0013\t\r#$!A\u0005\u0002\n\u0015\u0003\"\u0003B&5\u0005\u0005I\u0011\u0011B'\u0011%\u0011yFGA\u0001\n\u0013\u0011\tG\u0002\u0004\u0002&\u0005\u0001\u0015q\u0005\u0005\u000b\u0003'\u0001#Q3A\u0005\u0002\u0005U\u0001BCA&A\tE\t\u0015!\u0003\u0002\u0018!Q\u0011Q\n\u0011\u0003\u0016\u0004%\t!a\u0014\t\u0015\u0005]\u0003E!E!\u0002\u0013\t\t\u0006\u0003\u0004}A\u0011\u0005\u0011\u0011\f\u0005\b\u0003C\u0002C\u0011AA2\u0011%\t\t\bIA\u0001\n\u0003\t\u0019\bC\u0005\u0002z\u0001\n\n\u0011\"\u0001\u0002|!I\u0011\u0011\u0013\u0011\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003/\u0003\u0013\u0011!C!\u00033C\u0011\"a+!\u0003\u0003%\t!!,\t\u0013\u0005U\u0006%!A\u0005\u0002\u0005]\u0006\"CAbA\u0005\u0005I\u0011IAc\u0011%\t\u0019\u000eIA\u0001\n\u0003\t)\u000eC\u0005\u0002`\u0002\n\t\u0011\"\u0011\u0002b\"I\u0011Q\u001d\u0011\u0002\u0002\u0013\u0005\u0013q\u001d\u0005\n\u0003S\u0004\u0013\u0011!C!\u0003WD\u0011\"!<!\u0003\u0003%\t%a<\b\u0013\t%\u0014!!A\t\u0002\t-d!CA\u0013\u0003\u0005\u0005\t\u0012\u0001B7\u0011\u0019aH\u0007\"\u0001\u0003r!I\u0011\u0011\u001e\u001b\u0002\u0002\u0013\u0015\u00131\u001e\u0005\n\u0005\u0007\"\u0014\u0011!CA\u0005gB\u0011Ba\u00135\u0003\u0003%\tI!\u001f\t\u0013\t}C'!A\u0005\n\t\u0005dA\u0002BA\u0003\u0001\u0013\u0019\t\u0003\u0006\u0003\u0006j\u0012)\u001a!C\u0001\u0005\u000fC!Ba$;\u0005#\u0005\u000b\u0011\u0002BE\u0011\u0019a(\b\"\u0001\u0003\u0012\"9!q\u0013\u001e\u0005\u0002\te\u0005b\u0002BVu\u0011\u0005!Q\u0016\u0005\n\u0003cR\u0014\u0011!C\u0001\u0005cC\u0011\"!\u001f;#\u0003%\tA!.\t\u0013\u0005]%(!A\u0005B\u0005e\u0005\"CAVu\u0005\u0005I\u0011AAW\u0011%\t)LOA\u0001\n\u0003\u0011I\fC\u0005\u0002Dj\n\t\u0011\"\u0011\u0002F\"I\u00111\u001b\u001e\u0002\u0002\u0013\u0005!Q\u0018\u0005\n\u0003?T\u0014\u0011!C!\u0005\u0003D\u0011\"!:;\u0003\u0003%\t%a:\t\u0013\u0005%((!A\u0005B\u0005-\b\"CAwu\u0005\u0005I\u0011\tBc\u000f%\u0011I-AA\u0001\u0012\u0003\u0011YMB\u0005\u0003\u0002\u0006\t\t\u0011#\u0001\u0003N\"1A\u0010\u0014C\u0001\u0005+D\u0011\"!;M\u0003\u0003%)%a;\t\u0013\t\rC*!A\u0005\u0002\n]\u0007\"\u0003B&\u0019\u0006\u0005I\u0011\u0011Bn\u0011%\u0011y\u0006TA\u0001\n\u0013\u0011\tGB\u0003uO\u0002\u0011\t\u000f\u0003\u0006\u0003dJ\u0013\t\u0011)A\u0005\u0005KD!B!=S\u0005\u0003\u0005\u000b\u0011\u0002Bz\u0011)\u0011yP\u0015B\u0001B\u0003%1\u0011\u0001\u0005\u000b\u0007\u000f\u0011&\u0011!Q\u0001\n\r%\u0001BCB\u000f%\n\u0005\t\u0015!\u0003\u0004 !Q1q\u0006*\u0003\u0006\u0004%\ta!\r\t\u0015\r\r#K!A!\u0002\u0013\u0019\u0019\u0004\u0003\u0006\u0004FI\u0013)\u0019!C\u0001\u0007\u000fB!b!\u0016S\u0005\u0003\u0005\u000b\u0011BB%\u0011\u0019a(\u000b\"\u0001\u0004X!911\u0010*\u0005\u0002\ru\u0004bBBh%\u0012%1\u0011\u001b\u0005\b\u0007o\u0014F\u0011BB}\u0011\u001d!yA\u0015C\u0005\t#Aq\u0001b\tS\t\u0013!)\u0003C\u0004\u00054I#I\u0001\"\u000e\t\u000f\u0011\u0015#\u000b\"\u0003\u0005H!9Aq\u000b*\u0005\n\u0011e\u0003bBBh%\u0012%A1O\u0001\u001a\u001b\u0006LGNY8y'\u0016$8I]3bi\u0016\u0004VM\u001d4pe6,'O\u0003\u0002iS\u00061Q.\u001a;i_\u0012T!A[6\u0002\t)l\u0017\r\u001d\u0006\u0003Y6\fQA[1nKNT!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO\u000e\u0001\u0001CA:\u0002\u001b\u00059'!G'bS2\u0014w\u000e_*fi\u000e\u0013X-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0003e\fQa]2bY\u0006L!a\u001f=\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!/\u0001\u0004M\u001f\u001e;UIU\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fy\u0017!B:mMRR\u0017\u0002BA\u0006\u0003\u000b\u0011a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000b\t\u0002\u0016\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]J+7/\u001e7u'\t)a/A\tnC&d'm\u001c=De\u0016\fG/[8o\u0013\u0012,\"!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\bj\u0003\u0011i\u0017-\u001b7\n\t\u0005\u0005\u00121\u0004\u0002\u0012\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]&#\u0017fA\u0003!\u000f\t1R*Y5mE>D8I]3bi&|gNR1jYV\u0014Xm\u0005\u0005!m\u0006%\u0012QFA\u001a!\r\tY#B\u0007\u0002\u0003A\u0019q/a\f\n\u0007\u0005E\u0002PA\u0004Qe>$Wo\u0019;\u0011\t\u0005U\u0012Q\t\b\u0005\u0003o\t\tE\u0004\u0003\u0002:\u0005}RBAA\u001e\u0015\r\ti$]\u0001\u0007yI|w\u000e\u001e \n\u0003eL1!a\u0011y\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0012\u0002J\ta1+\u001a:jC2L'0\u00192mK*\u0019\u00111\t=\u0002%5\f\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:LE\rI\u0001\nKb\u001cW\r\u001d;j_:,\"!!\u0015\u0011\t\u0005U\u00121K\u0005\u0005\u0003+\nIEA\u0005Fq\u000e,\u0007\u000f^5p]\u0006QQ\r_2faRLwN\u001c\u0011\u0015\r\u0005m\u0013QLA0!\r\tY\u0003\t\u0005\b\u0003')\u0003\u0019AA\f\u0011\u001d\ti%\na\u0001\u0003#\n\u0011#Y:NC&d'm\u001c=TKR,%O]8s+\t\t)\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\r\tY'[\u0001\u0005G>\u0014X-\u0003\u0003\u0002p\u0005%$\u0001C*fi\u0016\u0013(o\u001c:\u0002\t\r|\u0007/\u001f\u000b\u0007\u00037\n)(a\u001e\t\u0013\u0005Mq\u0005%AA\u0002\u0005]\u0001\"CA'OA\u0005\t\u0019AA)\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!! +\t\u0005]\u0011qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0012=\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAKU\u0011\t\t&a \u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\n\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\t1\fgn\u001a\u0006\u0003\u0003K\u000bAA[1wC&!\u0011\u0011VAP\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0016\t\u0004o\u0006E\u0016bAAZq\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011XA`!\r9\u00181X\u0005\u0004\u0003{C(aA!os\"I\u0011\u0011\u0019\u0017\u0002\u0002\u0003\u0007\u0011qV\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0007CBAe\u0003\u001f\fI,\u0004\u0002\u0002L*\u0019\u0011Q\u001a=\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002R\u0006-'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a6\u0002^B\u0019q/!7\n\u0007\u0005m\u0007PA\u0004C_>dW-\u00198\t\u0013\u0005\u0005g&!AA\u0002\u0005e\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a'\u0002d\"I\u0011\u0011Y\u0018\u0002\u0002\u0003\u0007\u0011qV\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qV\u0001\ti>\u001cFO]5oOR\u0011\u00111T\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\u0017\u0011\u001f\u0005\n\u0003\u0003\u0014\u0014\u0011!a\u0001\u0003s\u0013a#T1jY\n|\u0007p\u0011:fCRLwN\\*vG\u000e,7o]\n\t\u000fY\fI#!\f\u00024\u00059R.Y5mE>D8I]3bi&|gNU3ta>t7/Z\u000b\u0003\u0003w\u0004B!!\u0007\u0002~&!\u0011q`A\u000e\u0005]i\u0015-\u001b7c_b\u001c%/Z1uS>t'+Z:q_:\u001cX-\u0001\rnC&d'm\u001c=De\u0016\fG/[8o%\u0016\u001c\bo\u001c8tK\u0002\"bA!\u0002\u0003\b\t%\u0001cAA\u0016\u000f!9\u00111\u0003\u0007A\u0002\u0005]\u0001bBA|\u0019\u0001\u0007\u00111 \u000b\u0007\u0005\u000b\u0011iAa\u0004\t\u0013\u0005MQ\u0002%AA\u0002\u0005]\u0001\"CA|\u001bA\u0005\t\u0019AA~+\t\u0011\u0019B\u000b\u0003\u0002|\u0006}D\u0003BA]\u0005/A\u0011\"!1\u0013\u0003\u0003\u0005\r!a,\u0015\t\u0005]'1\u0004\u0005\n\u0003\u0003$\u0012\u0011!a\u0001\u0003s#B!a'\u0003 !I\u0011\u0011Y\u000b\u0002\u0002\u0003\u0007\u0011q\u0016\u000b\u0005\u0003/\u0014\u0019\u0003C\u0005\u0002Bb\t\t\u00111\u0001\u0002:\u00061R*Y5mE>D8I]3bi&|gnU;dG\u0016\u001c8\u000fE\u0002\u0002,i\u0019RA\u0007B\u0016\u0005o\u0001\"B!\f\u00034\u0005]\u00111 B\u0003\u001b\t\u0011yCC\u0002\u00032a\fqA];oi&lW-\u0003\u0003\u00036\t=\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!\u0011\bB \u001b\t\u0011YD\u0003\u0003\u0003>\u0005\r\u0016AA5p\u0013\u0011\t9Ea\u000f\u0015\u0005\t\u001d\u0012!B1qa2LHC\u0002B\u0003\u0005\u000f\u0012I\u0005C\u0004\u0002\u0014u\u0001\r!a\u0006\t\u000f\u0005]X\u00041\u0001\u0002|\u00069QO\\1qa2LH\u0003\u0002B(\u00057\u0002Ra\u001eB)\u0005+J1Aa\u0015y\u0005\u0019y\u0005\u000f^5p]B9qOa\u0016\u0002\u0018\u0005m\u0018b\u0001B-q\n1A+\u001e9mKJB\u0011B!\u0018\u001f\u0003\u0003\u0005\rA!\u0002\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003dA!\u0011Q\u0014B3\u0013\u0011\u00119'a(\u0003\r=\u0013'.Z2u\u0003Yi\u0015-\u001b7c_b\u001c%/Z1uS>tg)Y5mkJ,\u0007cAA\u0016iM)AGa\u001c\u00038AQ!Q\u0006B\u001a\u0003/\t\t&a\u0017\u0015\u0005\t-DCBA.\u0005k\u00129\bC\u0004\u0002\u0014]\u0002\r!a\u0006\t\u000f\u00055s\u00071\u0001\u0002RQ!!1\u0010B@!\u00159(\u0011\u000bB?!\u001d9(qKA\f\u0003#B\u0011B!\u00189\u0003\u0003\u0005\r!a\u0017\u0003-5\u000b\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:\u0014Vm];miN\u001cbA\u000f<\u0002.\u0005M\u0012aB2sK\u0006$X\rZ\u000b\u0003\u0005\u0013\u0003b!!\u000e\u0003\f\u0006%\u0012\u0002\u0002BG\u0003\u0013\u00121aU3r\u0003!\u0019'/Z1uK\u0012\u0004C\u0003\u0002BJ\u0005+\u00032!a\u000b;\u0011\u001d\u0011))\u0010a\u0001\u0005\u0013\u000bqB]3ue&,g/Z\"sK\u0006$X\rZ\u000b\u0003\u00057\u0003\u0002B!(\u0003&\u0006]\u00111 \b\u0005\u0005?\u0013\t\u000bE\u0002\u0002:aL1Aa)y\u0003\u0019\u0001&/\u001a3fM&!!q\u0015BU\u0005\ri\u0015\r\u001d\u0006\u0004\u0005GC\u0018A\u0004:fiJLWM^3FeJ|'o]\u000b\u0003\u0005_\u0003\u0002B!(\u0003&\u0006]\u0011Q\r\u000b\u0005\u0005'\u0013\u0019\fC\u0005\u0003\u0006\u0002\u0003\n\u00111\u0001\u0003\nV\u0011!q\u0017\u0016\u0005\u0005\u0013\u000by\b\u0006\u0003\u0002:\nm\u0006\"CAa\t\u0006\u0005\t\u0019AAX)\u0011\t9Na0\t\u0013\u0005\u0005g)!AA\u0002\u0005eF\u0003BAN\u0005\u0007D\u0011\"!1H\u0003\u0003\u0005\r!a,\u0015\t\u0005]'q\u0019\u0005\n\u0003\u0003T\u0015\u0011!a\u0001\u0003s\u000ba#T1jY\n|\u0007p\u0011:fCRLwN\u001c*fgVdGo\u001d\t\u0004\u0003Wa5#\u0002'\u0003P\n]\u0002\u0003\u0003B\u0017\u0005#\u0014IIa%\n\t\tM'q\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDC\u0001Bf)\u0011\u0011\u0019J!7\t\u000f\t\u0015u\n1\u0001\u0003\nR!!Q\u001cBp!\u00159(\u0011\u000bBE\u0011%\u0011i\u0006UA\u0001\u0002\u0004\u0011\u0019j\u0005\u0002Sm\u0006Q1/\u001a:jC2L'0\u001a:\u0011\t\t\u001d(Q^\u0007\u0003\u0005ST1Aa;j\u0003\u0011Q7o\u001c8\n\t\t=(\u0011\u001e\u0002\u0012\u001b\u0006LGNY8y'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AD7bS2\u0014w\u000e_'b]\u0006<WM\u001d\t\u0005\u0005k\u0014Y0\u0004\u0002\u0003x*\u0019!\u0011`6\u0002\u000f5\f\u0017\u000e\u001c2pq&!!Q B|\u00059i\u0015-\u001b7c_bl\u0015M\\1hKJ\f1c];cg\u000e\u0014\u0018\u000e\u001d;j_:l\u0015M\\1hKJ\u0004BA!>\u0004\u0004%!1Q\u0001B|\u0005M\u0019VOY:de&\u0004H/[8o\u001b\u0006t\u0017mZ3s\u0003Ai\u0017-\u001b7c_bLEMR1di>\u0014\u0018\u0010\u0005\u0003\u0004\f\r]a\u0002BB\u0007\u0007'i!aa\u0004\u000b\t\rE!q_\u0001\u0006[>$W\r\\\u0005\u0005\u0007+\u0019y!A\u0005NC&d'm\u001c=JI&!1\u0011DB\u000e\u0005\u001d1\u0015m\u0019;pefTAa!\u0006\u0004\u0010\u0005a\u0011/^8uC\u001a\u000b7\r^8ssB!1\u0011EB\u0016\u001b\t\u0019\u0019C\u0003\u0003\u0004&\r\u001d\u0012AB9v_R\f7OC\u0002\u0004*%\fQ!\u001e;jYNLAa!\f\u0004$\t1\u0013+^8uC2{\u0017\rZ3s/&$\b\u000e\u0015:fY>\fG-\u001a3EK\u001a\fW\u000f\u001c;GC\u000e$xN]=\u0002\u001b5,GO]5d\r\u0006\u001cGo\u001c:z+\t\u0019\u0019\u0004\u0005\u0003\u00046\r}RBAB\u001c\u0015\u0011\u0019Ida\u000f\u0002\u0007\u0005\u0004\u0018NC\u0002\u0004>-\fq!\\3ue&\u001c7/\u0003\u0003\u0004B\r]\"!D'fiJL7MR1di>\u0014\u00180\u0001\bnKR\u0014\u0018n\u0019$bGR|'/\u001f\u0011\u0002\u001fM,7o]5p]N+\b\u000f\u001d7jKJ,\"a!\u0013\u0011\t\r-3\u0011K\u0007\u0003\u0007\u001bR1aa\u0014j\u0003\u0019\u0011x.\u001e;fg&!11KB'\u0005=\u0019Vm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001E:fgNLwN\\*vaBd\u0017.\u001a:!)A\u0019Ifa\u0017\u0004^\r}3\u0011MB2\u0007K\u001a9\u0007\u0005\u0002t%\"9!1\u001d/A\u0002\t\u0015\bb\u0002By9\u0002\u0007!1\u001f\u0005\b\u0005\u007fd\u0006\u0019AB\u0001\u0011\u001d\u00199\u0001\u0018a\u0001\u0007\u0013Aqa!\b]\u0001\u0004\u0019y\u0002C\u0004\u00040q\u0003\raa\r\t\u000f\r\u0015C\f1\u0001\u0004J!\u001aAla\u001b\u0011\t\r54qO\u0007\u0003\u0007_RAa!\u001d\u0004t\u00051\u0011N\u001c6fGRT!a!\u001e\u0002\u000f)\f7.\u0019:uC&!1\u0011PB8\u0005\u0019IeN[3di\u0006y1M]3bi\u0016l\u0015-\u001b7c_b,7\u000f\u0006\u0006\u0004\u0000\rM6QXBd\u0007\u0017\u0004ba!!\u0004\u0010\u000eMUBABB\u0015\u0011\u0019)ia\"\u0002\u0013A,(\r\\5tQ\u0016\u0014(bA=\u0004\n*!\u00111NBF\u0015\t\u0019i)A\u0004sK\u0006\u001cGo\u001c:\n\t\rE51\u0011\u0002\u0006'6{gn\u001c\t\bo\n]3QSBW!\r\u00199J\u000f\b\u0004\u00073\u0003a\u0002BBN\u0007WsAa!(\u0004*:!1qTBT\u001d\u0011\u0019\tk!*\u000f\t\u0005e21U\u0005\u0002a&\u0011an\\\u0005\u0003Y6L!A[6\n\u0005!L\u0007\u0003BB&\u0007_KAa!-\u0004N\t\t\u0002K]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\t\u000f\rUV\f1\u0001\u00048\u0006qQ.Y5mE>D8+Z:tS>t\u0007\u0003\u0002B{\u0007sKAaa/\u0003x\nqQ*Y5mE>D8+Z:tS>t\u0007bBB`;\u0002\u00071\u0011Y\u0001\u0012[\u0006LGNY8y'\u0016$(+Z9vKN$\b\u0003BA\r\u0007\u0007LAa!2\u0002\u001c\t\tR*Y5mE>D8+\u001a;SKF,Xm\u001d;\t\u000f\r%W\f1\u0001\u0004.\u0006\t\u0002O]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\t\u000f\r5W\f1\u0001\u0002X\u0006!2/\u001e9q_J$8\u000b[1sK\u0012l\u0015-\u001b7c_b\fQb\u0019:fCR,W*Y5mE>DH\u0003DBj\u0007/\u001cIna7\u0004t\u000eU\bcB<\u0003X\rU7Q\u0016\t\u0004\u0007/+\u0001bBB[=\u0002\u00071q\u0017\u0005\b\u0003'q\u0006\u0019AA\f\u0011\u001d\u0019iN\u0018a\u0001\u0007?\f\u0001B[:PE*,7\r\u001e\t\u0005\u0007C\u001cy/\u0004\u0002\u0004d*!!1^Bs\u0015\u0011\u00199o!;\u0002\t1L'm\u001d\u0006\u0005\u0007s\u0019YO\u0003\u0002\u0004n\u0006!\u0001\u000f\\1z\u0013\u0011\u0019\tpa9\u0003\u0011)\u001bxJ\u00196fGRDqa!3_\u0001\u0004\u0019i\u000bC\u0004\u0004Nz\u0003\r!a6\u0002\u0017A\f'o]3De\u0016\fG/\u001a\u000b\u0005\u0007w$i\u0001\u0005\u0005\u00026\ruH\u0011\u0001C\u0004\u0013\u0011\u0019y0!\u0013\u0003\r\u0015KG\u000f[3s!\r\u0019H1A\u0005\u0004\t\u000b9'!H'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8QCJ\u001cX-\u0012=dKB$\u0018n\u001c8\u0011\t\u0005eA\u0011B\u0005\u0005\t\u0017\tYB\u0001\fNC&d'm\u001c=De\u0016\fG/[8o%\u0016\fX/Z:u\u0011\u001d\u0019in\u0018a\u0001\u0007?\f1B]3t_24X\rU1uQRAA1\u0003C\u000e\t;!\t\u0003\u0005\u0005\u00026\ru\u0018\u0011\u000bC\u000b!\u0011\u0019i\u0001b\u0006\n\t\u0011e1q\u0002\u0002\f\u001b\u0006LGNY8y!\u0006$\b\u000eC\u0004\u00046\u0002\u0004\raa.\t\u000f\u0011}\u0001\r1\u0001\u0005\b\u00051R.Y5mE>D8I]3bi&|gNU3rk\u0016\u001cH\u000fC\u0004\u0004N\u0002\u0004\r!a6\u0002\u0019I,GO]5fm\u0016\u0004\u0016\r\u001e5\u0015\r\u0011MAq\u0005C\u0019\u0011\u001d!I#\u0019a\u0001\tW\t\u0011\"\\1jY\n|\u00070\u00133\u0011\t\r5AQF\u0005\u0005\t_\u0019yAA\u0005NC&d'm\u001c=JI\"91QW1A\u0002\r]\u0016!\t<bY&$\u0017\r^3DCB\f'-\u001b7jifLem\u00155be\u0016$W*Y5mE>DH\u0003\u0003C\u001c\t{!y\u0004b\u0011\u0011\u000f]$I\u0004\"\u0006\u0005\u0014%\u0019A1\b=\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBB[E\u0002\u00071q\u0017\u0005\b\t\u0003\u0012\u0007\u0019\u0001C\u0016\u0003\tIG\rC\u0004\u0004N\n\u0004\r!a6\u0002GI,7m\u001c:e\u0007J,\u0017\r^5p]&#\u0017J\u001c)s_\u000e,7o]5oO\u000e{g\u000e^3yiRAA\u0011\nC)\t'\")\u0006\u0005\u0005\u00026\ruH1JBW!\u0011\t)\u0004\"\u0014\n\t\u0011=\u0013\u0011\n\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBA\nG\u0002\u0007\u0011q\u0003\u0005\b\u0007\u0013\u001c\u0007\u0019ABW\u0011\u001d!Ic\u0019a\u0001\tW\tq\"\\1jY\n|\u0007pU3u\u000bJ\u0014xN\u001d\u000b\u0005\u0003K\"Y\u0006C\u0004\u0005^\u0011\u0004\r\u0001b\u0018\u0002\r\u0015\u0014(o\u001c:t!\u0019\tI\r\"\u0019\u0005d%!!QRAf!\u001d9(q\u000bC3\tW\u0002Ba!9\u0005h%!A\u0011NBr\u0005\u0019Q5\u000fU1uQB1\u0011\u0011\u001aC1\t[\u0002Ba!9\u0005p%!A\u0011OBr\u0005MQ5o\u001c8WC2LG-\u0019;j_:,%O]8s)!!)\bb\u001e\u0005z\u0011u\u0004\u0003CA\u001b\u0007{\f\t&a?\t\u000f\rUV\r1\u0001\u00048\"9A1P3A\u0002\u0011U\u0011\u0001\u00029bi\"Dq\u0001b\bf\u0001\u0004!9\u0001")
public class MailboxSetCreatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final QuotaLoaderWithPreloadedDefaultFactory quotaFactory;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;

    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public SMono<Tuple2<MailboxCreationResults, ProcessingContext>> createMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, ProcessingContext processingContext, boolean supportSharedMailbox) {
        return SFlux$.MODULE$.fromIterable((Iterable)((MapOps)mailboxSetRequest.create().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).view()).fold((Object)new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)Nil$.MODULE$), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MailboxCreationId mailboxCreationId = (MailboxCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mailboxCreationId, (Object)jsObject);
            MailboxCreationId mailboxCreationId2 = (MailboxCreationId)tuple22._1();
            JsObject jsObject2 = (JsObject)tuple22._2();
            Tuple2<MailboxCreationResult, ProcessingContext> tuple23 = this.createMailbox(mailboxSession, mailboxCreationId2, jsObject2, (ProcessingContext)acc._2(), supportSharedMailbox);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            MailboxCreationResult creationResult = (MailboxCreationResult)tuple23._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            MailboxCreationResult creationResult2 = (MailboxCreationResult)tuple24._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple24._2();
            return new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)((scala.collection.immutable.Seq)((MailboxCreationResults)acc._1()).created().$colon$plus((Object)creationResult2))), (Object)updatedProcessingContext2);
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private Tuple2<MailboxCreationResult, ProcessingContext> createMailbox(MailboxSession mailboxSession, MailboxCreationId mailboxCreationId, JsObject jsObject, ProcessingContext processingContext, boolean supportSharedMailbox) {
        return (Tuple2)this.parseCreate(jsObject).flatMap((Function1 & Serializable)mailboxCreationRequest -> this.resolvePath(mailboxSession, (MailboxCreationRequest)mailboxCreationRequest, supportSharedMailbox).flatMap((Function1 & Serializable)path -> this.createMailbox(mailboxSession, (MailboxPath)path, (MailboxCreationRequest)mailboxCreationRequest))).flatMap((Function1 & Serializable)creationResponse -> this.recordCreationIdInProcessingContext(mailboxCreationId, processingContext, creationResponse.id()).map((Function1 & Serializable)context -> new Tuple2(creationResponse, context))).fold((Function1 & Serializable)e -> new Tuple2((Object)new MailboxCreationFailure(mailboxCreationId, (Exception)e), (Object)processingContext), (Function1 & Serializable)creationResponseWithUpdatedContext -> new Tuple2((Object)new MailboxCreationSuccess(mailboxCreationId, (MailboxCreationResponse)creationResponseWithUpdatedContext._1()), creationResponseWithUpdatedContext._2()));
    }

    private Either<MailboxCreationParseException, MailboxCreationRequest> parseCreate(JsObject jsObject) {
        return MailboxCreationRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJsObject -> {
            JsResult jsResult = Json$.MODULE$.fromJson((JsValue)validJsObject, $this.serializer.mailboxCreationRequest());
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MailboxCreationRequest creationRequest = (MailboxCreationRequest)jsSuccess.value();
                return new Right((Object)creationRequest);
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                return new Left((Object)new MailboxCreationParseException(this.mailboxSetError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors)));
            }
            throw new MatchError((Object)jsResult);
        });
    }

    private Either<Exception, MailboxPath> resolvePath(MailboxSession mailboxSession, MailboxCreationRequest mailboxCreationRequest, boolean supportSharedMailbox) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(mailboxCreationRequest.name()), mailboxSession.getPathDelimiter())) {
            return new Left((Object)new MailboxNameException("The mailbox '" + mailboxCreationRequest.name() + "' contains an illegal character: '" + mailboxSession.getPathDelimiter() + "'"));
        }
        return (Either)mailboxCreationRequest.parentId().map((Function1 & Serializable)maybeParentId -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.mailboxIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)maybeParentId.id()), RefType$.MODULE$.refinedRefType()))).toEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.getMessage(), (Throwable)e)).flatMap((Function1 & Serializable)parentId -> this.retrievePath((MailboxId)parentId, mailboxSession).flatMap((Function1 & Serializable)parentPathPreAssert -> ((Either)this.validateCapabilityIfSharedMailbox(mailboxSession, (MailboxId)parentId, supportSharedMailbox).apply(parentPathPreAssert)).map((Function1 & Serializable)parentPath -> parentPath.child((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType()), mailboxSession.getPathDelimiter()))))).getOrElse((Function0 & Serializable)() -> new Right((Object)MailboxPath.forUser((Username)mailboxSession.getUser(), (String)((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType())))));
    }

    private Either<Exception, MailboxPath> retrievePath(MailboxId mailboxId, MailboxSession mailboxSession) {
        Right right;
        try {
            right = new Right((Object)this.mailboxManager.getMailbox(mailboxId, mailboxSession).getMailboxPath());
        }
        catch (Exception e) {
            right = new Left((Object)e);
        }
        return right;
    }

    private Function1<MailboxPath, Either<Exception, MailboxPath>> validateCapabilityIfSharedMailbox(MailboxSession mailboxSession, MailboxId id, boolean supportSharedMailbox) {
        return (Function1 & Serializable)mailboxPath -> {
            if (!mailboxPath.belongsTo(mailboxSession) && !supportSharedMailbox) {
                return new Left((Object)new MailboxNotFoundException(id));
            }
            return new Right(mailboxPath);
        };
    }

    private Either<IllegalArgumentException, ProcessingContext> recordCreationIdInProcessingContext(MailboxCreationId mailboxCreationId, ProcessingContext processingContext, MailboxId mailboxId) {
        return Id$.MODULE$.validate(mailboxId.serialize()).map((Function1 & Serializable)serverAssignedId -> processingContext.recordCreatedId(new ClientId(mailboxCreationId.id()), new ServerId((String)((Refined)serverAssignedId).value())));
    }

    private SetError mailboxSetError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        return package$.MODULE$.standardError(errors);
    }

    private Either<Exception, MailboxCreationResponse> createMailbox(MailboxSession mailboxSession, MailboxPath path, MailboxCreationRequest mailboxCreationRequest) {
        Left left;
        try {
            MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(path, mailboxSession).get();
            boolean defaultSubscribed = true;
            if (((IsSubscribed)mailboxCreationRequest.isSubscribed().getOrElse((Function0 & Serializable)() -> new IsSubscribed(defaultSubscribed))).value()) {
                this.subscriptionManager.subscribe(mailboxSession, path);
            }
            mailboxCreationRequest.rights().foreach((Function1 & Serializable)rights -> {
                this.mailboxManager.setRights(mailboxId, rights.toMailboxAcl().asJava(), mailboxSession);
                return BoxedUnit.UNIT;
            });
            SMono qual$1 = this.quotaFactory.loadFor(mailboxSession).flatMap((Function1 & Serializable)quotaLoader -> quotaLoader.getQuotas(path));
            Duration x$1 = qual$1.block$default$1();
            Map<QuotaId, Quota> quotas = ((Quotas)qual$1.block(x$1)).quotas();
            MailboxId x$2 = mailboxId;
            SortOrder x$3 = SortOrder$.MODULE$.defaultSortOrder();
            None$ x$4 = None$.MODULE$;
            TotalEmails x$5 = new TotalEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadEmails x$6 = new UnreadEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            TotalThreads x$7 = new TotalThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadThreads x$8 = new UnreadThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            MailboxRights x$9 = MailboxRights$.MODULE$.FULL();
            Some x$10 = new Some((Object)new Quotas(quotas));
            None$ x$11 = mailboxCreationRequest.isSubscribed().isEmpty() ? new Some((Object)new IsSubscribed(defaultSubscribed)) : None$.MODULE$;
            Right right = new Right((Object)new MailboxCreationResponse(x$2, (Option<Role>)x$4, x$3, x$5, x$6, x$7, x$8, x$9, (Option<Quotas>)x$10, (Option<IsSubscribed>)x$11));
            left = right;
        }
        catch (Exception error) {
            left = new Left((Object)error);
        }
        return left;
    }

    @Inject
    public MailboxSetCreatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory, QuotaLoaderWithPreloadedDefaultFactory quotaFactory, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.quotaFactory = quotaFactory;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
    }

    public static class MailboxCreationFailure
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final Exception exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public Exception exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            Exception exception = this.exception();
            if (exception instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Can't create mailbox: Mailbox not found: {}", (Object)mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxNotFoundException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (exception instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Mailbox already exists: {}", (Object)mailboxExistsException.getMailboxName());
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            }
            if (exception instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Invalid mailbox name: {}", (Object)mailboxNameException.getMessage());
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            }
            if (exception instanceof MailboxCreationParseException) {
                MailboxCreationParseException mailboxCreationParseException = (MailboxCreationParseException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Failed to parse mailbox creation request", (Throwable)mailboxCreationParseException);
                return mailboxCreationParseException.setError();
            }
            if (exception instanceof InsufficientRightsException) {
                InsufficientRightsException insufficientRightsException = (InsufficientRightsException)exception;
                MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().info("Insufficient rights to create a mailbox", (Throwable)insufficientRightsException);
                return SetError$.MODULE$.forbidden("Insufficient rights", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            MailboxSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetCreatePerformer$$LOGGER().error("Failed to create mailbox", (Throwable)exception);
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxCreationFailure copy(MailboxCreationId mailboxCreationId, Exception exception) {
            return new MailboxCreationFailure(mailboxCreationId, exception);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public Exception copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxCreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxCreationId();
                }
                case 1: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxCreationId";
                }
                case 1: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationFailure.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            Exception exception = this.exception();
            Exception exception2 = mailboxCreationFailure.exception();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!mailboxCreationFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationFailure(MailboxCreationId mailboxCreationId, Exception exception) {
            this.mailboxCreationId = mailboxCreationId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxCreationResult {
        public MailboxCreationId mailboxCreationId();
    }

    public static class MailboxCreationResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<MailboxCreationResult> created;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> created() {
            return this.created;
        }

        public Map<MailboxCreationId, MailboxCreationResponse> retrieveCreated() {
            return (Map)((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationSuccess) {
                    MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)mailboxCreationResult;
                    return new Some((Object)new Tuple2((Object)mailboxCreationSuccess.mailboxCreationId(), (Object)mailboxCreationSuccess.mailboxCreationResponse()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)creation -> new Tuple2(creation._1(), creation._2()));
        }

        public Map<MailboxCreationId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationFailure) {
                    MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)mailboxCreationResult;
                    return new Some((Object)new Tuple2((Object)mailboxCreationFailure.mailboxCreationId(), (Object)mailboxCreationFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxCreationResults copy(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            return new MailboxCreationResults(created);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> copy$default$1() {
            return this.created();
        }

        public String productPrefix() {
            return "MailboxCreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.created();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "created";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationResults mailboxCreationResults = (MailboxCreationResults)x$1;
            scala.collection.immutable.Seq<MailboxCreationResult> seq = this.created();
            scala.collection.immutable.Seq<MailboxCreationResult> seq2 = mailboxCreationResults.created();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxCreationResults.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationResults(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            this.created = created;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxCreationSuccess
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final MailboxCreationResponse mailboxCreationResponse;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public MailboxCreationResponse mailboxCreationResponse() {
            return this.mailboxCreationResponse;
        }

        public MailboxCreationSuccess copy(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            return new MailboxCreationSuccess(mailboxCreationId, mailboxCreationResponse);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public MailboxCreationResponse copy$default$2() {
            return this.mailboxCreationResponse();
        }

        public String productPrefix() {
            return "MailboxCreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxCreationId();
                }
                case 1: {
                    return this.mailboxCreationResponse();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxCreationId";
                }
                case 1: {
                    return "mailboxCreationResponse";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationSuccess.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            MailboxCreationResponse mailboxCreationResponse = this.mailboxCreationResponse();
            MailboxCreationResponse mailboxCreationResponse2 = mailboxCreationSuccess.mailboxCreationResponse();
            if (mailboxCreationResponse == null) {
                if (mailboxCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationResponse).equals(mailboxCreationResponse2)) return false;
            if (!mailboxCreationSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationSuccess(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            this.mailboxCreationId = mailboxCreationId;
            this.mailboxCreationResponse = mailboxCreationResponse;
            Product.$init$((Product)this);
        }
    }
}

