/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.roaringbitmap;

import java.util.BitSet;
import java.util.stream.IntStream;
import org.apache.pulsar.shade.org.roaringbitmap.BitSetUtil;
import org.apache.pulsar.shade.org.roaringbitmap.RoaringBitmap;

public class RoaringBitSet
extends BitSet {
    private static final long serialVersionUID = 1L;
    private final RoaringBitmap roaringBitmap;

    public RoaringBitSet() {
        super(0);
        this.roaringBitmap = new RoaringBitmap();
    }

    private RoaringBitSet(RoaringBitmap roaringBitmap) {
        super(0);
        this.roaringBitmap = roaringBitmap;
    }

    @Override
    public void set(int bitIndex) {
        this.roaringBitmap.add(bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.roaringBitmap.add(bitIndex);
        } else {
            this.roaringBitmap.remove(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        this.roaringBitmap.add((long)fromIndex, (long)toIndex);
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.roaringBitmap.add((long)fromIndex, (long)toIndex);
        } else {
            this.roaringBitmap.remove((long)fromIndex, (long)toIndex);
        }
    }

    @Override
    public void clear(int bitIndex) {
        this.roaringBitmap.remove(bitIndex);
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        this.roaringBitmap.remove((long)fromIndex, (long)toIndex);
    }

    @Override
    public void clear() {
        this.roaringBitmap.clear();
    }

    @Override
    public boolean get(int bitIndex) {
        return this.roaringBitmap.contains(bitIndex);
    }

    @Override
    public BitSet get(int fromIndex, int toIndex) {
        RoaringBitmap newBitmap = this.roaringBitmap.selectRange(fromIndex, toIndex);
        newBitmap = RoaringBitmap.addOffset(newBitmap, -fromIndex);
        return new RoaringBitSet(newBitmap);
    }

    @Override
    public int nextSetBit(int fromIndex) {
        return (int)this.roaringBitmap.nextValue(fromIndex);
    }

    @Override
    public int nextClearBit(int fromIndex) {
        return (int)this.roaringBitmap.nextAbsentValue(fromIndex);
    }

    @Override
    public int previousSetBit(int fromIndex) {
        return (int)this.roaringBitmap.previousValue(fromIndex);
    }

    @Override
    public int previousClearBit(int fromIndex) {
        return (int)this.roaringBitmap.previousAbsentValue(fromIndex);
    }

    @Override
    public int length() {
        if (this.roaringBitmap.isEmpty()) {
            return 0;
        }
        return this.roaringBitmap.last() + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.roaringBitmap.isEmpty();
    }

    @Override
    public boolean intersects(BitSet set) {
        if (set instanceof RoaringBitSet) {
            return RoaringBitmap.intersects(this.roaringBitmap, ((RoaringBitSet)set).roaringBitmap);
        }
        return RoaringBitmap.intersects(this.roaringBitmap, RoaringBitSet.fromBitSet(set));
    }

    @Override
    public int cardinality() {
        return this.roaringBitmap.getCardinality();
    }

    @Override
    public void and(BitSet set) {
        if (set instanceof RoaringBitSet) {
            this.roaringBitmap.and(((RoaringBitSet)set).roaringBitmap);
        } else {
            this.roaringBitmap.and(RoaringBitSet.fromBitSet(set));
        }
    }

    @Override
    public void or(BitSet set) {
        if (set instanceof RoaringBitSet) {
            this.roaringBitmap.or(((RoaringBitSet)set).roaringBitmap);
        } else {
            this.roaringBitmap.or(RoaringBitSet.fromBitSet(set));
        }
    }

    @Override
    public void xor(BitSet set) {
        if (set instanceof RoaringBitSet) {
            this.roaringBitmap.xor(((RoaringBitSet)set).roaringBitmap);
        } else {
            this.roaringBitmap.xor(RoaringBitSet.fromBitSet(set));
        }
    }

    @Override
    public void andNot(BitSet set) {
        if (set instanceof RoaringBitSet) {
            this.roaringBitmap.andNot(((RoaringBitSet)set).roaringBitmap);
        } else {
            this.roaringBitmap.andNot(RoaringBitSet.fromBitSet(set));
        }
    }

    @Override
    public int hashCode() {
        return this.roaringBitmap.hashCode();
    }

    @Override
    public int size() {
        if (this.roaringBitmap.isEmpty()) {
            return 0;
        }
        int lastBit = Math.max(this.length(), 64);
        int remainder = lastBit % 64;
        return remainder == 0 ? lastBit : lastBit + 64 - remainder;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RoaringBitSet) {
            return this.roaringBitmap.equals(((RoaringBitSet)obj).roaringBitmap);
        }
        return false;
    }

    @Override
    public Object clone() {
        return new RoaringBitSet(this.roaringBitmap.clone());
    }

    @Override
    public IntStream stream() {
        return this.roaringBitmap.stream();
    }

    @Override
    public String toString() {
        return this.roaringBitmap.toString();
    }

    @Override
    public void flip(int bitIndex) {
        this.roaringBitmap.flip((long)bitIndex, (long)bitIndex + 1L);
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        this.roaringBitmap.flip((long)fromIndex, (long)toIndex);
    }

    @Override
    public long[] toLongArray() {
        return BitSetUtil.toLongArray(this.roaringBitmap);
    }

    @Override
    public byte[] toByteArray() {
        return BitSetUtil.toByteArray(this.roaringBitmap);
    }

    private static RoaringBitmap fromBitSet(BitSet bitSet) {
        return BitSetUtil.bitmapOf(bitSet);
    }
}

