/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import java.util.Optional;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import reactor.netty.http.server.HttpServerRequest;
import reactor.util.context.Context;

public interface LoggingHelper {
    public static Context jmapAuthContext(MailboxSession session) {
        return ReactorUtils.context((String)"JMAP_AUTH", (MDCBuilder)MDCBuilder.ofValue((String)"user", (String)session.getUser().asString()));
    }

    public static Context jmapContext(HttpServerRequest req) {
        return ReactorUtils.context((String)"JMAP", (MDCBuilder)MDCBuilder.create().addToContext("protocol", "JMAP").addToContext("ip", req.hostAddress().getHostString()).addToContextIfPresent("real-ip", Optional.ofNullable(req.requestHeaders().getAsString((CharSequence)"X-Real-IP"))));
    }

    public static Context jmapAction(String action) {
        return ReactorUtils.context((String)"JMAP_ACTION", (MDCBuilder)MDCBuilder.ofValue((String)"action", (String)action));
    }
}

