/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class GsubProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final String pattern;
    private final String replacement;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<GsubProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GsubProcessor::setupGsubProcessorDeserializer);

    private GsubProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.replacement = ApiTypeHelper.requireNonNull(builder.replacement, this, "replacement");
        this.targetField = builder.targetField;
    }

    public static GsubProcessor of(Function<Builder, ObjectBuilder<GsubProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Gsub;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final String replacement() {
        return this.replacement;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
        generator.writeKey("replacement");
        generator.write(this.replacement);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    protected static void setupGsubProcessorDeserializer(ObjectDeserializer<Builder> op) {
        GsubProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GsubProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private String pattern;
        private String replacement;
        @Nullable
        private String targetField;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public final Builder replacement(String value) {
            this.replacement = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GsubProcessor build() {
            this._checkSingleUse();
            return new GsubProcessor(this);
        }
    }
}

