/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.slf4j.Logger;

public class ProcessorUtil {
    public static void handleException(Throwable me, Mail mail, String offendersName, String nextState, Logger logger) {
        mail.setState(nextState);
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        String exceptionBuffer = "Exception calling " + offendersName + ": " + me.getMessage();
        out.println(exceptionBuffer);
        Throwable e = me;
        while (e != null) {
            e.printStackTrace(out);
            if (e instanceof MessagingException) {
                e = ((MessagingException)e).getNextException();
                continue;
            }
            e = null;
        }
        String errorString = sout.toString();
        mail.setErrorMessage(errorString);
        logger.error(errorString);
        mail.setAttribute(new Attribute(Mail.MAILET_ERROR, AttributeValue.ofUnserializable((Object)me)));
    }

    public static void verifyMailAddresses(Collection<MailAddress> col) throws MessagingException {
        try {
            MailAddress[] addresses = (MailAddress[])col.toArray(MailAddress[]::new);
            if (addresses.length != col.size()) {
                throw new MailetException("The recipient list contains objects other than MailAddress objects");
            }
        }
        catch (ArrayStoreException ase) {
            throw new MailetException("The recipient list contains objects other than MailAddress objects");
        }
    }
}

