/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.partition.executor.hash;

import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.tsfile.file.metadata.IDeviceID;

public class BKDRHashExecutor
extends SeriesPartitionExecutor {
    private static final int SEED = 131;

    public BKDRHashExecutor(int deviceGroupCount) {
        super(deviceGroupCount);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(String device) {
        int hash = 0;
        for (int i = 0; i < device.length(); ++i) {
            hash = hash * 131 + device.charAt(i);
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }

    @Override
    public TSeriesPartitionSlot getSeriesPartitionSlot(IDeviceID deviceID) {
        int hash = 0;
        int segmentNum = deviceID.segmentNum();
        for (int segmentID = 0; segmentID < segmentNum; ++segmentID) {
            Object segment = deviceID.segment(segmentID);
            if (segment instanceof String) {
                String segmentStr = (String)segment;
                for (int i = 0; i < segmentStr.length(); ++i) {
                    hash = hash * 131 + segmentStr.charAt(i);
                }
            } else {
                hash = hash * 131 + 65536;
            }
            if (segmentID >= segmentNum - 1) continue;
            hash = hash * 131 + 46;
        }
        return new TSeriesPartitionSlot((hash &= Integer.MAX_VALUE) % this.seriesPartitionSlotNum);
    }
}

