/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.plugin;

import java.io.IOException;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.confignode.consensus.request.read.pipe.plugin.GetPipePluginJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.pipe.plugin.GetPipePluginTablePlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.pipe.plugin.PipePluginTableResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.pipe.PipePluginInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetJarInListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipePluginReq;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePluginCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginCoordinator.class);
    private final ConfigManager configManager;
    private final PipePluginInfo pipePluginInfo;

    public PipePluginCoordinator(ConfigManager configManager, PipePluginInfo pipePluginInfo) {
        this.configManager = configManager;
        this.pipePluginInfo = pipePluginInfo;
    }

    public PipePluginInfo getPipePluginInfo() {
        return this.pipePluginInfo;
    }

    public void lock() {
        this.pipePluginInfo.acquirePipePluginInfoLock();
    }

    public void unlock() {
        this.pipePluginInfo.releasePipePluginInfoLock();
    }

    public TSStatus createPipePlugin(TCreatePipePluginReq req) {
        String pluginName = req.getPluginName().toUpperCase();
        String className = req.getClassName();
        String jarName = req.getJarName();
        String jarMD5 = req.getJarMD5();
        PipePluginMeta pipePluginMeta = new PipePluginMeta(pluginName, className, false, jarName, jarMD5);
        return this.configManager.getProcedureManager().createPipePlugin(pipePluginMeta, req.getJarFile(), req.isSetIfNotExistsCondition() && req.isIfNotExistsCondition());
    }

    public TSStatus dropPipePlugin(TDropPipePluginReq req) {
        boolean isSetIfExistsCondition;
        String pluginName = req.getPluginName();
        boolean bl = isSetIfExistsCondition = req.isSetIfExistsCondition() && req.isIfExistsCondition();
        if (!this.pipePluginInfo.isPipePluginExisted(pluginName, req.isTableModel)) {
            return isSetIfExistsCondition ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.DROP_PIPE_PLUGIN_ERROR, (String)String.format("Failed to drop pipe plugin %s. Failures: %s does not exist.", pluginName, pluginName));
        }
        return this.configManager.getProcedureManager().dropPipePlugin(req);
    }

    public TGetPipePluginTableResp getPipePluginTable() {
        try {
            return ((PipePluginTableResp)this.configManager.getConsensusManager().read(new GetPipePluginTablePlan())).convertToThriftResponse();
        }
        catch (IOException | ConsensusException e) {
            LOGGER.error("Fail to get PipePluginTable", e);
            return new TGetPipePluginTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetPipePluginTableResp getPipePluginTableExtended(TShowPipePluginReq req) {
        try {
            return ((PipePluginTableResp)this.configManager.getConsensusManager().read(new GetPipePluginTablePlan())).filter(req.isTableModel).convertToThriftResponse();
        }
        catch (IOException | ConsensusException e) {
            LOGGER.error("Fail to get PipePluginTable", e);
            return new TGetPipePluginTableResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(e.getMessage()), Collections.emptyList());
        }
    }

    public TGetJarInListResp getPipePluginJar(TGetJarInListReq req) {
        try {
            return ((JarResp)this.configManager.getConsensusManager().read(new GetPipePluginJarPlan(req.getJarNameList()))).convertToThriftResponse();
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new JarResp(res, Collections.emptyList()).convertToThriftResponse();
        }
    }
}

