/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.persistence.calls;

import org.apache.ignite.migrationtools.cli.persistence.calls.MigrateCacheCall;
import org.apache.ignite.migrationtools.cli.persistence.params.IgniteClientAuthenticatorParams;
import org.apache.ignite.migrationtools.cli.persistence.params.MigrateCacheParams;
import org.apache.ignite.migrationtools.cli.persistence.params.PersistenceParams;
import org.apache.ignite.migrationtools.cli.persistence.params.RetrieableMigrateCacheParams;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.logger.CliLoggers;
import org.apache.ignite3.internal.logger.IgniteLogger;

public class RetriableMigrateCacheCall
implements Call<Input, MigrateCacheCall.Ouput> {
    private static final IgniteLogger LOGGER = CliLoggers.forClass(MigrateCacheCall.class);
    private final MigrateCacheCall migrateCacheCall;

    public RetriableMigrateCacheCall(MigrateCacheCall migrateCacheCall) {
        this.migrateCacheCall = migrateCacheCall;
    }

    public CallOutput<MigrateCacheCall.Ouput> execute(Input i) {
        int retryLimit = i.retryParams().retryLimit();
        int retryBackoffSeconds = i.retryParams().retryBackoffSeconds();
        if (retryLimit < 0) {
            LOGGER.error("retryLimit must be >= 0 times, but was {}", new Object[]{retryLimit});
            return DefaultCallOutput.failure((Throwable)new IgniteCliException("retryLimit must be >= 0 times, but was " + retryLimit));
        }
        if (retryBackoffSeconds < 0) {
            LOGGER.error("retryBackoff must be >= 0 seconds, but was {}", new Object[]{retryBackoffSeconds});
            return DefaultCallOutput.failure((Throwable)new IgniteCliException("retryBackoff must be >= 0 seconds, but was " + retryBackoffSeconds));
        }
        if (retryLimit > 0 && i.migrateCacheParams().saveProgressFileDisabled()) {
            LOGGER.error("--no-save-progress cannot be used with --retryLimit > 0", new Object[0]);
            return DefaultCallOutput.failure((Throwable)new IgniteCliException("--no-save-progress cannot be used with --retryLimit > 0"));
        }
        MigrateCacheParams migrateCacheParams = i.migrateCacheParams();
        for (int atempt = 0; atempt < retryLimit; ++atempt) {
            CallOutput<MigrateCacheCall.Ouput> status = this.migrateCacheCall.execute(new MigrateCacheCall.Input(i.persistenceParams(), migrateCacheParams, i.clientAuthenticatorParams()));
            if (status.errorCause() == null || !status.errorCause().getMessage().equals("Error while migrating persistence folder")) {
                return status;
            }
            LOGGER.warn("Cache migration attempt {} failed. Will retry in {}s. {} attempts remaining.", new Object[]{atempt, retryBackoffSeconds, retryLimit - atempt});
            if (retryBackoffSeconds > 0) {
                try {
                    Thread.sleep((long)retryBackoffSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("Interrupted during retry attempt backoff.", new Object[0]);
                    return DefaultCallOutput.failure((Throwable)new IgniteCliException("Interrupted during retry attempt backoff.", (Throwable)e));
                }
            }
            migrateCacheParams = new MigrateCacheParams(migrateCacheParams.cacheName(), migrateCacheParams.addresses(), migrateCacheParams.migrationMode(), migrateCacheParams.rateLimiter(), migrateCacheParams.saveProgressFileDisabled(), ((MigrateCacheCall.Ouput)status.body()).getProgressFilePath());
        }
        CallOutput<MigrateCacheCall.Ouput> lastStatus = this.migrateCacheCall.execute(new MigrateCacheCall.Input(i.persistenceParams(), migrateCacheParams, i.clientAuthenticatorParams()));
        return lastStatus;
    }

    public static class Input
    implements CallInput {
        private final PersistenceParams persistenceParams;
        private final MigrateCacheParams migrateCacheParams;
        private final RetrieableMigrateCacheParams retryParms;
        private final IgniteClientAuthenticatorParams clientAuthenticatorParams;

        public Input(PersistenceParams persistenceParams, MigrateCacheParams migrateCacheParams, RetrieableMigrateCacheParams retryParms, IgniteClientAuthenticatorParams clientAuthenticatorParams) {
            this.persistenceParams = persistenceParams;
            this.migrateCacheParams = migrateCacheParams;
            this.retryParms = retryParms;
            this.clientAuthenticatorParams = clientAuthenticatorParams;
        }

        PersistenceParams persistenceParams() {
            return this.persistenceParams;
        }

        MigrateCacheParams migrateCacheParams() {
            return this.migrateCacheParams;
        }

        RetrieableMigrateCacheParams retryParams() {
            return this.retryParms;
        }

        IgniteClientAuthenticatorParams clientAuthenticatorParams() {
            return this.clientAuthenticatorParams;
        }
    }
}

