/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload.pipeline;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.internal.processors.bulkload.pipeline.PipelineBlock;

public class CharsetDecoderBlock
extends PipelineBlock<byte[], char[]> {
    public static final char[] EMPTY_PORTION = new char[0];
    private final CharsetDecoder charsetDecoder;
    private byte[] leftover;
    private boolean isEndOfInput;

    public CharsetDecoderBlock(Charset charset) {
        this.charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.isEndOfInput = false;
        this.leftover = null;
    }

    @Override
    public void accept(byte[] data, boolean isLastAppend) throws IgniteCheckedException {
        block13: {
            CoderResult res;
            ByteBuffer dataBuf;
            assert (this.nextBlock != null);
            assert (!this.isEndOfInput) : "convertBytes() called after end of input";
            this.isEndOfInput = isLastAppend;
            if (this.leftover == null && data.length == 0) {
                this.nextBlock.accept(EMPTY_PORTION, isLastAppend);
                return;
            }
            if (this.leftover == null) {
                dataBuf = ByteBuffer.wrap(data);
            } else {
                dataBuf = ByteBuffer.allocate(this.leftover.length + data.length);
                dataBuf.put(this.leftover).put(data);
                dataBuf.flip();
                this.leftover = null;
            }
            int outBufLen = (int)Math.ceil(this.charsetDecoder.maxCharsPerByte() * (float)(data.length + 1));
            assert (outBufLen > 0);
            CharBuffer outBuf = CharBuffer.allocate(outBufLen);
            while (true) {
                if ((res = this.charsetDecoder.decode(dataBuf, outBuf, this.isEndOfInput)).isUnderflow()) {
                    if (!this.isEndOfInput && dataBuf.remaining() > 0) {
                        this.leftover = Arrays.copyOfRange(dataBuf.array(), dataBuf.arrayOffset() + dataBuf.position(), dataBuf.limit());
                    }
                    if (this.isEndOfInput) {
                        this.charsetDecoder.flush(outBuf);
                    }
                    if (outBuf.position() > 0) {
                        this.nextBlock.accept(Arrays.copyOfRange(outBuf.array(), outBuf.arrayOffset(), outBuf.position()), this.isEndOfInput);
                    }
                    break block13;
                }
                if (!res.isOverflow()) break;
                assert (outBuf.position() > 0);
                this.nextBlock.accept(Arrays.copyOfRange(outBuf.array(), outBuf.arrayOffset(), outBuf.position()), this.isEndOfInput);
                outBuf.flip();
            }
            assert (!res.isMalformed() && !res.isUnmappable());
            throw new IgniteIllegalStateException("Unknown CharsetDecoder state");
        }
    }
}

