/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class QueryConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private List<String> sqlFuncClss;
    private long longQryWarnTimeout;
    private boolean sqlEscapeAll;
    private List<String> indexedTypes;
    private String sqlSchema;

    public QueryConfiguration() {
    }

    public QueryConfiguration(CacheConfiguration ccfg) {
        this.sqlFuncClss = VisorTaskUtils.compactClasses(ccfg.getSqlFunctionClasses());
        this.longQryWarnTimeout = ccfg.getLongQueryWarningTimeout();
        this.sqlEscapeAll = ccfg.isSqlEscapeAll();
        this.indexedTypes = VisorTaskUtils.compactClasses(ccfg.getIndexedTypes());
        this.sqlSchema = ccfg.getSqlSchema();
    }

    public List<String> getSqlFunctionClasses() {
        return this.sqlFuncClss;
    }

    public long getLongQueryWarningTimeout() {
        return this.longQryWarnTimeout;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public List<String> getIndexedTypes() {
        return this.indexedTypes;
    }

    public String getSqlSchema() {
        return this.sqlSchema;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.sqlFuncClss);
        out.writeLong(this.longQryWarnTimeout);
        out.writeBoolean(this.sqlEscapeAll);
        U.writeCollection(out, this.indexedTypes);
        U.writeString(out, this.sqlSchema);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.sqlFuncClss = U.readList(in);
        this.longQryWarnTimeout = in.readLong();
        this.sqlEscapeAll = in.readBoolean();
        this.indexedTypes = U.readList(in);
        this.sqlSchema = U.readString(in);
    }

    public String toString() {
        return S.toString(QueryConfiguration.class, this);
    }
}

