/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.replicator.ZonePartitionId;

public class ZoneMetricSource
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "zones";
    public static final String LOCAL_UNREBALANCED_PARTITIONS_COUNT = "LocalUnrebalancedPartitionsCount";
    public static final String TOTAL_UNREBALANCED_PARTITIONS_COUNT = "TotalUnrebalancedPartitionsCount";
    private final MetaStorageManager metaStorageManager;
    private final String nodeName;
    public final CatalogZoneDescriptor zoneDescriptor;

    public ZoneMetricSource(MetaStorageManager metaStorageManager, String consistentId, CatalogZoneDescriptor zoneDescriptor) {
        super("zones." + zoneDescriptor.name(), "Distribution zone metrics.", SOURCE_NAME);
        this.nodeName = consistentId;
        this.zoneDescriptor = zoneDescriptor;
        this.metaStorageManager = metaStorageManager;
    }

    protected Holder createHolder() {
        return new Holder(this);
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final List<Metric> metrics;

        Holder(ZoneMetricSource source) {
            IntGauge localUnrebalancedPartitionsCount = new IntGauge(ZoneMetricSource.LOCAL_UNREBALANCED_PARTITIONS_COUNT, "The number of partitions that should be moved to this node.", () -> {
                int unrebalancedParts = 0;
                for (int i = 0; i < source.zoneDescriptor.partitions(); ++i) {
                    ZonePartitionId zonePartitionId = new ZonePartitionId(source.zoneDescriptor.id(), i);
                    Entry pendingEntry = source.metaStorageManager.getLocally(ZoneRebalanceUtil.pendingPartAssignmentsQueueKey(zonePartitionId));
                    AssignmentsQueue pendingAssignmentsQueue = AssignmentsQueue.fromBytes((byte[])pendingEntry.value());
                    if (pendingAssignmentsQueue == null) continue;
                    Entry stableEntry = source.metaStorageManager.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey(zonePartitionId));
                    Assignments stableAssignments = stableEntry.value() == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])stableEntry.value());
                    Assignments targetAssignments = pendingAssignmentsQueue.peekLast();
                    boolean stable = Holder.presentInAssignments(stableAssignments, source.nodeName);
                    boolean pending = Holder.presentInAssignments(targetAssignments, source.nodeName);
                    if (stable || !pending) continue;
                    ++unrebalancedParts;
                }
                return unrebalancedParts;
            });
            IntGauge totalUnrebalancedPartitionsCount = new IntGauge(ZoneMetricSource.TOTAL_UNREBALANCED_PARTITIONS_COUNT, "The total number of partitions that should be moved to a new owner.", () -> {
                int unrebalancedParts = 0;
                for (int i = 0; i < source.zoneDescriptor.partitions(); ++i) {
                    ZonePartitionId zonePartitionId = new ZonePartitionId(source.zoneDescriptor.id(), i);
                    Entry pendingEntry = source.metaStorageManager.getLocally(ZoneRebalanceUtil.pendingPartAssignmentsQueueKey(zonePartitionId));
                    AssignmentsQueue pendingAssignmentsQueue = AssignmentsQueue.fromBytes((byte[])pendingEntry.value());
                    if (pendingAssignmentsQueue == null) continue;
                    Entry stableEntry = source.metaStorageManager.getLocally(ZoneRebalanceUtil.stablePartAssignmentsKey(zonePartitionId));
                    Assignments stableAssignments = stableEntry.value() == null ? Assignments.EMPTY : Assignments.fromBytes((byte[])stableEntry.value());
                    Assignments targetAssignments = pendingAssignmentsQueue.peekLast();
                    for (Assignment pendingAssignment : targetAssignments.nodes()) {
                        if (Holder.presentInAssignments(stableAssignments, pendingAssignment.consistentId())) continue;
                        ++unrebalancedParts;
                    }
                }
                return unrebalancedParts;
            });
            this.metrics = List.of(localUnrebalancedPartitionsCount, totalUnrebalancedPartitionsCount);
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }

        private static boolean presentInAssignments(Assignments assignments, String nodeName) {
            return assignments.nodes().stream().anyMatch(assignment -> assignment.consistentId().equals(nodeName));
        }
    }
}

