/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignmentsImpl;
import org.apache.ignite.internal.placementdriver.AssignmentsPlacementDriver;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class AssignmentsTracker
implements AssignmentsPlacementDriver {
    private static final IgniteLogger LOG = Loggers.forClass(AssignmentsTracker.class);
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final MetaStorageManager msManager;
    private final Map<ReplicationGroupId, TokenizedAssignments> groupStableAssignments;
    private final WatchListener stableAssignmentsListener;
    private final Map<ReplicationGroupId, TokenizedAssignments> groupPendingAssignments;
    private final WatchListener pendingAssignmentsListener;

    public AssignmentsTracker(MetaStorageManager msManager) {
        this.msManager = msManager;
        this.groupStableAssignments = new ConcurrentHashMap<ReplicationGroupId, TokenizedAssignments>();
        this.stableAssignmentsListener = this.createStableAssignmentsListener();
        this.groupPendingAssignments = new ConcurrentHashMap<ReplicationGroupId, TokenizedAssignments>();
        this.pendingAssignmentsListener = this.createPendingAssignmentsListener();
    }

    public void startTrack() {
        this.msManager.registerPrefixWatch(new ByteArray(RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES), this.pendingAssignmentsListener);
        this.msManager.registerPrefixWatch(new ByteArray(RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES), this.stableAssignmentsListener);
        ((CompletableFuture)this.msManager.recoveryFinishedFuture().thenAccept(recoveryRevisions -> {
            this.handleRecoveryAssignments((Revisions)recoveryRevisions, RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES, this.groupPendingAssignments);
            this.handleRecoveryAssignments((Revisions)recoveryRevisions, RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES, this.groupStableAssignments);
        })).whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.error("Cannot do recovery", ex);
            }
        });
        LOG.info("Assignment cache initialized for placement driver [groupStableAssignments={}, groupPendingAssignments={}]", new Object[]{this.groupStableAssignments, this.groupPendingAssignments});
    }

    public void stopTrack() {
        this.msManager.unregisterWatch(this.pendingAssignmentsListener);
        this.msManager.unregisterWatch(this.stableAssignmentsListener);
    }

    public CompletableFuture<List<TokenizedAssignments>> getAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp clusterTimeToAwait) {
        return this.msManager.clusterTime().waitFor(clusterTimeToAwait).thenApply(ignored -> (List)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            Map<ReplicationGroupId, TokenizedAssignments> assignments = this.stableAssignments();
            return replicationGroupIds.stream().map(assignments::get).collect(Collectors.toList());
        }));
    }

    Map<ReplicationGroupId, TokenizedAssignments> stableAssignments() {
        return this.groupStableAssignments;
    }

    Map<ReplicationGroupId, TokenizedAssignments> pendingAssignments() {
        return this.groupPendingAssignments;
    }

    private WatchListener createStableAssignmentsListener() {
        return event -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stable assignments update [revision={}, keys={}]", new Object[]{event.revision(), AssignmentsTracker.collectKeysFromEventAsString(event)});
            }
            AssignmentsTracker.handleReceivedAssignments(event, RebalanceUtil.STABLE_ASSIGNMENTS_PREFIX_BYTES, this.groupStableAssignments);
            return CompletableFutures.nullCompletedFuture();
        };
    }

    private WatchListener createPendingAssignmentsListener() {
        return event -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pending assignments update [revision={}, keys={}]", new Object[]{event.revision(), AssignmentsTracker.collectKeysFromEventAsString(event)});
            }
            AssignmentsTracker.handleReceivedAssignments(event, RebalanceUtil.PENDING_ASSIGNMENTS_PREFIX_BYTES, this.groupPendingAssignments);
            return CompletableFutures.nullCompletedFuture();
        };
    }

    private static void handleReceivedAssignments(WatchEvent event, byte[] assignmentsMetastoreKeyPrefix, Map<ReplicationGroupId, TokenizedAssignments> groupIdToAssignmentsMap) {
        for (EntryEvent evt : event.entryEvents()) {
            Entry entry = evt.newEntry();
            TablePartitionId grpId = RebalanceUtil.extractTablePartitionId((byte[])entry.key(), (byte[])assignmentsMetastoreKeyPrefix);
            if (entry.tombstone()) {
                groupIdToAssignmentsMap.remove(grpId);
                continue;
            }
            AssignmentsTracker.updateGroupAssignments(groupIdToAssignmentsMap, (ReplicationGroupId)grpId, entry);
        }
    }

    private void handleRecoveryAssignments(Revisions recoveryRevisions, byte[] assignmentsMetastoreKeyPrefix, Map<ReplicationGroupId, TokenizedAssignments> groupIdToAssignmentsMap) {
        ByteArray prefix = new ByteArray(assignmentsMetastoreKeyPrefix);
        long revision = recoveryRevisions.revision();
        try (Cursor cursor = this.msManager.prefixLocally(prefix, revision);){
            for (Entry entry : cursor) {
                if (entry.tombstone()) continue;
                TablePartitionId grpId = RebalanceUtil.extractTablePartitionId((byte[])entry.key(), (byte[])assignmentsMetastoreKeyPrefix);
                AssignmentsTracker.updateGroupAssignments(groupIdToAssignmentsMap, (ReplicationGroupId)grpId, entry);
            }
        }
    }

    private static void updateGroupAssignments(Map<ReplicationGroupId, TokenizedAssignments> groupIdToAssignmentsMap, ReplicationGroupId grpId, Entry entry) {
        byte[] value = entry.value();
        assert (value != null);
        Set assignmentNodes = Assignments.fromBytes((byte[])value).nodes();
        groupIdToAssignmentsMap.put(grpId, (TokenizedAssignments)new TokenizedAssignmentsImpl(assignmentNodes, entry.revision()));
    }

    private static String collectKeysFromEventAsString(WatchEvent event) {
        return event.entryEvents().stream().map(e -> new ByteArray(e.newEntry().key()).toString()).collect(Collectors.joining(","));
    }
}

