/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdMeasure
implements MetadataHandler<BuiltInMetadata.Measure> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdMeasure(), BuiltInMetadata.Measure.Handler.class);

    @Override
    public MetadataDef<BuiltInMetadata.Measure> getDef() {
        return BuiltInMetadata.Measure.DEF;
    }

    public Boolean isMeasure(RelNode rel, RelMetadataQuery mq, int column) {
        return false;
    }

    public RexNode expand(RelNode rel, RelMetadataQuery mq, int column, BuiltInMetadata.Measure.Context context) {
        throw new UnsupportedOperationException("expand(" + rel + ", " + column + ", " + context);
    }

    public RexNode expand(RelSubset subset, RelMetadataQuery mq, int column, BuiltInMetadata.Measure.Context context) {
        Iterator<RelNode> iterator = subset.getRels().iterator();
        if (iterator.hasNext()) {
            RelNode rel = iterator.next();
            return mq.expand(rel, column, context);
        }
        return this.expand((RelNode)subset, mq, column, context);
    }

    public RexNode expand(Filter filter, RelMetadataQuery mq, int column, BuiltInMetadata.Measure.Context context) {
        return mq.expand(filter.getInput().stripped(), column, context);
    }

    public @Nullable RexNode expand(Project project, RelMetadataQuery mq, int column, BuiltInMetadata.Measure.Context context) {
        RexNode e = project.getProjects().get(column);
        BuiltInMetadata.Measure.Context context2 = Contexts.forProject(project, context);
        switch (e.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)e;
                return mq.expand(project.getInput().stripped(), ref.getIndex(), context2);
            }
            case V2M: {
                RexCall call = (RexCall)e;
                RexSubQuery scalarQuery = context.getRelBuilder().scalarQuery(b -> b.push(project.getInput().stripped()).filter(context2.getFilters((RelBuilder)b)).aggregateRex(b.groupKey(), (RexNode)call.operands.get(0)).build());
                RelDataType measureType = SqlTypeUtil.fromMeasure(context.getTypeFactory(), call.type);
                if (!measureType.isNullable()) {
                    return context.getRexBuilder().makeNotNull(scalarQuery);
                }
                return scalarQuery;
            }
        }
        throw new AssertionError((Object)("unexpected expression [" + e + "], kind [" + (Object)((Object)e.getKind()) + "]"));
    }

    public @Nullable RexNode expand(Aggregate aggregate, RelMetadataQuery mq, int column, BuiltInMetadata.Measure.Context context) {
        AggregateCall e = aggregate.getAggCallList().get(column - aggregate.getGroupCount());
        if (e.getAggregation().getKind() != SqlKind.AGG_M2M) {
            throw new AssertionError(e);
        }
        int arg = (Integer)Iterables.getOnlyElement(e.getArgList());
        return mq.expand(aggregate.getInput().stripped(), arg, context);
    }

    public static abstract class DelegatingContext
    implements BuiltInMetadata.Measure.Context {
        protected final BuiltInMetadata.Measure.Context context;

        protected DelegatingContext(BuiltInMetadata.Measure.Context context) {
            this.context = context;
        }

        @Override
        public RelBuilder getRelBuilder() {
            return this.context.getRelBuilder();
        }

        @Override
        public List<RexNode> getFilters(RelBuilder b) {
            return this.context.getFilters(b);
        }

        @Override
        public int getDimensionCount() {
            return this.context.getDimensionCount();
        }
    }

    public static class Contexts {
        private static BuiltInMetadata.Measure.Context forProject(final Project project, BuiltInMetadata.Measure.Context context) {
            return new DelegatingContext(context){

                @Override
                public List<RexNode> getFilters(RelBuilder b) {
                    List<RexNode> filters = this.context.getFilters(b);
                    return new RexShuttle(){

                        @Override
                        public RexNode visitInputRef(RexInputRef inputRef) {
                            return project.getProjects().get(inputRef.getIndex());
                        }
                    }.apply(filters);
                }

                @Override
                public int getDimensionCount() {
                    return (int)project.getInput().getRowType().getFieldList().stream().filter(f -> !f.getType().isMeasure()).count();
                }
            };
        }

        public static BuiltInMetadata.Measure.Context forAggregate(final Aggregate aggregate, final Supplier<RelBuilder> builderSupplier, final RexCorrelVariable v) {
            return new BuiltInMetadata.Measure.Context(){

                @Override
                public RelBuilder getRelBuilder() {
                    return (RelBuilder)builderSupplier.get();
                }

                @Override
                public int getDimensionCount() {
                    return aggregate.getGroupCount();
                }

                @Override
                public List<RexNode> getFilters(RelBuilder b) {
                    ArrayList<RexNode> filters = new ArrayList<RexNode>();
                    aggregate.getGroupSet().forEachInt(i -> filters.add(b.equals(b.field(i), b.field((RexNode)v, filters.size()))));
                    return filters;
                }
            };
        }
    }
}

