/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.AbstractDouble2ObjectMap;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.Double2ObjectMaps;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.Double2ObjectSortedMap;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.doubles.DoubleSortedSets;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import org.apache.ignite.shaded.it.unimi.dsi.fastutil.objects.ObjectSortedSets;

public final class Double2ObjectSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Double2ObjectSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Double, ?>> entryComparator(DoubleComparator comparator) {
        return (x, y) -> comparator.compare((double)((Double)x.getKey()), (double)((Double)y.getKey()));
    }

    public static <V> ObjectBidirectionalIterator<Double2ObjectMap.Entry<V>> fastIterator(Double2ObjectSortedMap<V> map) {
        ObjectSet entries = map.double2ObjectEntrySet();
        return entries instanceof Double2ObjectSortedMap.FastSortedEntrySet ? ((Double2ObjectSortedMap.FastSortedEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static <V> ObjectBidirectionalIterable<Double2ObjectMap.Entry<V>> fastIterable(Double2ObjectSortedMap<V> map) {
        ObjectSet entries = map.double2ObjectEntrySet();
        return entries instanceof Double2ObjectSortedMap.FastSortedEntrySet ? ((Double2ObjectSortedMap.FastSortedEntrySet)entries)::fastIterator : entries;
    }

    public static <V> Double2ObjectSortedMap<V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <V> Double2ObjectSortedMap<V> singleton(Double key, V value) {
        return new Singleton<V>(key, value);
    }

    public static <V> Double2ObjectSortedMap<V> singleton(Double key, V value, DoubleComparator comparator) {
        return new Singleton<V>(key, value, comparator);
    }

    public static <V> Double2ObjectSortedMap<V> singleton(double key, V value) {
        return new Singleton<V>(key, value);
    }

    public static <V> Double2ObjectSortedMap<V> singleton(double key, V value, DoubleComparator comparator) {
        return new Singleton<V>(key, value, comparator);
    }

    public static <V> Double2ObjectSortedMap<V> synchronize(Double2ObjectSortedMap<V> m4) {
        return new SynchronizedSortedMap<V>(m4);
    }

    public static <V> Double2ObjectSortedMap<V> synchronize(Double2ObjectSortedMap<V> m4, Object sync) {
        return new SynchronizedSortedMap<V>(m4, sync);
    }

    public static <V> Double2ObjectSortedMap<V> unmodifiable(Double2ObjectSortedMap<? extends V> m4) {
        return new UnmodifiableSortedMap<V>(m4);
    }

    public static class EmptySortedMap<V>
    extends Double2ObjectMaps.EmptyMap<V>
    implements Double2ObjectSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public DoubleComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Double2ObjectMap.Entry<V>> double2ObjectEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Double, V>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public DoubleSortedSet keySet() {
            return DoubleSortedSets.EMPTY_SET;
        }

        @Override
        public Double2ObjectSortedMap<V> subMap(double from, double to) {
            return EMPTY_MAP;
        }

        @Override
        public Double2ObjectSortedMap<V> headMap(double to) {
            return EMPTY_MAP;
        }

        @Override
        public Double2ObjectSortedMap<V> tailMap(double from) {
            return EMPTY_MAP;
        }

        @Override
        public double firstDoubleKey() {
            throw new NoSuchElementException();
        }

        @Override
        public double lastDoubleKey() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> headMap(Double oto) {
            return this.headMap((double)oto);
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> tailMap(Double ofrom) {
            return this.tailMap((double)ofrom);
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> subMap(Double ofrom, Double oto) {
            return this.subMap((double)ofrom, (double)oto);
        }

        @Override
        @Deprecated
        public Double firstKey() {
            return this.firstDoubleKey();
        }

        @Override
        @Deprecated
        public Double lastKey() {
            return this.lastDoubleKey();
        }
    }

    public static class Singleton<V>
    extends Double2ObjectMaps.Singleton<V>
    implements Double2ObjectSortedMap<V>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleComparator comparator;

        protected Singleton(double key, V value, DoubleComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(double key, V value) {
            this(key, value, null);
        }

        final int compare(double k1, double k2) {
            return this.comparator == null ? Double.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public DoubleComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Double2ObjectMap.Entry<V>> double2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new AbstractDouble2ObjectMap.BasicEntry<Object>(this.key, this.value), Double2ObjectSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Double, V>> entrySet() {
            return this.double2ObjectEntrySet();
        }

        @Override
        public DoubleSortedSet keySet() {
            if (this.keys == null) {
                this.keys = DoubleSortedSets.singleton(this.key, this.comparator);
            }
            return (DoubleSortedSet)this.keys;
        }

        @Override
        public Double2ObjectSortedMap<V> subMap(double from, double to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Double2ObjectSortedMap<V> headMap(double to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Double2ObjectSortedMap<V> tailMap(double from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public double firstDoubleKey() {
            return this.key;
        }

        @Override
        public double lastDoubleKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> headMap(Double oto) {
            return this.headMap((double)oto);
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> tailMap(Double ofrom) {
            return this.tailMap((double)ofrom);
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> subMap(Double ofrom, Double oto) {
            return this.subMap((double)ofrom, (double)oto);
        }

        @Override
        @Deprecated
        public Double firstKey() {
            return this.firstDoubleKey();
        }

        @Override
        @Deprecated
        public Double lastKey() {
            return this.lastDoubleKey();
        }
    }

    public static class SynchronizedSortedMap<V>
    extends Double2ObjectMaps.SynchronizedMap<V>
    implements Double2ObjectSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Double2ObjectSortedMap<V> sortedMap;

        protected SynchronizedSortedMap(Double2ObjectSortedMap<V> m4, Object sync) {
            super(m4, sync);
            this.sortedMap = m4;
        }

        protected SynchronizedSortedMap(Double2ObjectSortedMap<V> m4) {
            super(m4);
            this.sortedMap = m4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DoubleComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Double2ObjectMap.Entry<V>> double2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.double2ObjectEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Double, V>> entrySet() {
            return this.double2ObjectEntrySet();
        }

        @Override
        public DoubleSortedSet keySet() {
            if (this.keys == null) {
                this.keys = DoubleSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (DoubleSortedSet)this.keys;
        }

        @Override
        public Double2ObjectSortedMap<V> subMap(double from, double to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from, to), this.sync);
        }

        @Override
        public Double2ObjectSortedMap<V> headMap(double to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        public Double2ObjectSortedMap<V> tailMap(double from) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double firstDoubleKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstDoubleKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double lastDoubleKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastDoubleKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> subMap(Double from, Double to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.subMap(from, to), this.sync);
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> headMap(Double to) {
            return new SynchronizedSortedMap<V>(this.sortedMap.headMap(to), this.sync);
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> tailMap(Double from) {
            return new SynchronizedSortedMap<V>(this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class UnmodifiableSortedMap<V>
    extends Double2ObjectMaps.UnmodifiableMap<V>
    implements Double2ObjectSortedMap<V>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Double2ObjectSortedMap<? extends V> sortedMap;

        protected UnmodifiableSortedMap(Double2ObjectSortedMap<? extends V> m4) {
            super(m4);
            this.sortedMap = m4;
        }

        @Override
        public DoubleComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Double2ObjectMap.Entry<V>> double2ObjectEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.double2ObjectEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Double, V>> entrySet() {
            return this.double2ObjectEntrySet();
        }

        @Override
        public DoubleSortedSet keySet() {
            if (this.keys == null) {
                this.keys = DoubleSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (DoubleSortedSet)this.keys;
        }

        @Override
        public Double2ObjectSortedMap<V> subMap(double from, double to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from, to));
        }

        @Override
        public Double2ObjectSortedMap<V> headMap(double to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to));
        }

        @Override
        public Double2ObjectSortedMap<V> tailMap(double from) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from));
        }

        @Override
        public double firstDoubleKey() {
            return this.sortedMap.firstDoubleKey();
        }

        @Override
        public double lastDoubleKey() {
            return this.sortedMap.lastDoubleKey();
        }

        @Override
        @Deprecated
        public Double firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        @Deprecated
        public Double lastKey() {
            return this.sortedMap.lastKey();
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> subMap(Double from, Double to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.subMap(from, to));
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> headMap(Double to) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.headMap(to));
        }

        @Override
        @Deprecated
        public Double2ObjectSortedMap<V> tailMap(Double from) {
            return new UnmodifiableSortedMap<V>(this.sortedMap.tailMap(from));
        }
    }
}

