/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.HashUtils;
import org.apache.ignite.internal.util.TemporalTypeUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class HashCalculator {
    private int hash = 0;

    public void append(@Nullable Object v, int scale, int precision) {
        if (v == null) {
            this.appendNull();
            return;
        }
        if (v.getClass() == Boolean.class) {
            this.appendBoolean((Boolean)v);
        } else if (v.getClass() == Byte.class) {
            this.appendByte((Byte)v);
        } else if (v.getClass() == Short.class) {
            this.appendShort((Short)v);
        } else if (v.getClass() == Integer.class) {
            this.appendInt((Integer)v);
        } else if (v.getClass() == Long.class) {
            this.appendLong((Long)v);
        } else if (v.getClass() == Float.class) {
            this.appendFloat(((Float)v).floatValue());
        } else if (v.getClass() == Double.class) {
            this.appendDouble((Double)v);
        } else if (v.getClass() == BigDecimal.class) {
            this.appendDecimal((BigDecimal)v, scale);
        } else if (v.getClass() == UUID.class) {
            this.appendUuid((UUID)v);
        } else if (v.getClass() == LocalDate.class) {
            this.appendDate((LocalDate)v);
        } else if (v.getClass() == LocalTime.class) {
            this.appendTime((LocalTime)v, precision);
        } else if (v.getClass() == LocalDateTime.class) {
            this.appendDateTime((LocalDateTime)v, precision);
        } else if (v.getClass() == Instant.class) {
            this.appendTimestamp((Instant)v, precision);
        } else if (v.getClass() == byte[].class) {
            this.appendBytes((byte[])v);
        } else if (v.getClass() == String.class) {
            this.appendString((String)v);
        } else {
            throw new IgniteInternalException("Unsupported value type: [cls=" + String.valueOf(v.getClass()) + "]");
        }
    }

    public void appendNull() {
        this.appendByte((byte)0);
    }

    public void appendBoolean(boolean v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashBoolean(v));
    }

    public static int hashBoolean(boolean v) {
        return HashUtils.hash32(ByteUtils.booleanToByte(v));
    }

    public void appendByte(byte v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashByte(v));
    }

    public static int hashByte(byte v) {
        return HashUtils.hash32(v);
    }

    public void appendShort(short v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashShort(v));
    }

    public static int hashShort(short v) {
        return HashUtils.hash32(v);
    }

    public void appendInt(int v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashInt(v));
    }

    public static int hashInt(int v) {
        return HashUtils.hash32(v);
    }

    public void appendLong(long v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashLong(v));
    }

    public static int hashLong(long v) {
        return HashUtils.hash32(v);
    }

    public void appendFloat(float v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashFloat(v));
    }

    public static int hashFloat(float v) {
        return HashUtils.hash32(Float.floatToRawIntBits(v));
    }

    public void appendDouble(double v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashDouble(v));
    }

    public static int hashDouble(double v) {
        return HashUtils.hash32(Double.doubleToRawLongBits(v));
    }

    public void appendDecimal(BigDecimal v, int columnScale) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashDecimal(v, columnScale));
    }

    public static int hashDecimal(BigDecimal v, int columnScale) {
        return HashCalculator.hashBytes(v.setScale(columnScale, RoundingMode.HALF_UP).unscaledValue().toByteArray());
    }

    public void appendUuid(UUID v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashUuid(v));
    }

    public static int hashUuid(UUID v) {
        return HashUtils.hash32(v.getLeastSignificantBits(), HashUtils.hash32(v.getMostSignificantBits()));
    }

    public void appendString(String v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashString(v));
    }

    public static int hashString(String v) {
        return HashCalculator.hashBytes(v.getBytes(StandardCharsets.UTF_8));
    }

    public void appendBytes(byte[] v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashBytes(v));
    }

    public static int hashBytes(byte[] v) {
        return HashUtils.hash32(v);
    }

    public void appendDate(LocalDate v) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashDate(v));
    }

    public static int hashDate(LocalDate v) {
        return HashUtils.hash32(v.getDayOfMonth(), HashUtils.hash32(v.getMonthValue(), HashUtils.hash32(v.getYear())));
    }

    public void appendTime(LocalTime v, int precision) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashTime(v, precision));
    }

    public static int hashTime(LocalTime v, int precision) {
        int hourHash = HashUtils.hash32(v.getHour());
        int minuteHash = HashUtils.hash32(v.getMinute(), hourHash);
        int secondHash = HashUtils.hash32(v.getSecond(), minuteHash);
        return HashUtils.hash32(TemporalTypeUtils.normalizeNanos(v.getNano(), precision), secondHash);
    }

    public void appendDateTime(LocalDateTime v, int precision) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashDateTime(v, precision));
    }

    public static int hashDateTime(LocalDateTime v, int precision) {
        return HashUtils.combine(HashCalculator.hashDate(v.toLocalDate()), HashCalculator.hashTime(v.toLocalTime(), precision));
    }

    public void appendTimestamp(Instant v, int precision) {
        this.hash = HashUtils.combine(this.hash, HashCalculator.hashTimestamp(v, precision));
    }

    public static int hashTimestamp(Instant v, int precision) {
        return HashUtils.hash32(TemporalTypeUtils.normalizeNanos(v.getNano(), precision), HashCalculator.hashLong(v.getEpochSecond()));
    }

    public static int combinedHash(int[] hashes) {
        int hash = 0;
        for (int h2 : hashes) {
            hash = HashUtils.combine(hash, h2);
        }
        return hash;
    }

    public int hash() {
        return this.hash;
    }

    public void reset() {
        this.hash = 0;
    }
}

