/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.List;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.streamer.StreamerMetricSink;

public class ClientMetricSource
extends AbstractMetricSource<Holder>
implements StreamerMetricSink {
    ClientMetricSource() {
        super("client");
    }

    public long connectionsActive() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.connectionsActive.value();
    }

    public void connectionsActiveIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.connectionsActive.increment();
        }
    }

    public void connectionsActiveDecrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.connectionsActive.decrement();
        }
    }

    public long connectionsEstablished() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.connectionsEstablished.value();
    }

    public void connectionsEstablishedIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.connectionsEstablished.increment();
        }
    }

    public long connectionsLost() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.connectionsLost.value();
    }

    public void connectionsLostIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.connectionsLost.increment();
        }
    }

    public long connectionsLostTimeout() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.connectionsLostTimeout.value();
    }

    public void connectionsLostTimeoutIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.connectionsLostTimeout.increment();
        }
    }

    public long handshakesFailed() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.handshakesFailed.value();
    }

    public void handshakesFailedIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.handshakesFailed.increment();
        }
    }

    public long handshakesFailedTimeout() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.handshakesFailedTimeout.value();
    }

    public void handshakesFailedTimeoutIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.handshakesFailedTimeout.increment();
        }
    }

    public long requestsActive() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.requestsActive.value();
    }

    public void requestsActiveIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.requestsActive.increment();
        }
    }

    public void requestsActiveDecrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.requestsActive.decrement();
        }
    }

    public long requestsSent() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.requestsSent.value();
    }

    public void requestsSentIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.requestsSent.increment();
        }
    }

    public long requestsCompleted() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.requestsCompleted.value();
    }

    public void requestsCompletedIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.requestsCompleted.increment();
        }
    }

    public long requestsRetried() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.requestsRetried.value();
    }

    public void requestsRetriedIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.requestsRetried.increment();
        }
    }

    public long requestsFailed() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.requestsFailed.value();
    }

    public void requestsFailedIncrement() {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.requestsFailed.increment();
        }
    }

    public long bytesSent() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.bytesSent.value();
    }

    public void bytesSentAdd(long bytes) {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.bytesSent.add(bytes);
        }
    }

    public long bytesReceived() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.bytesReceived.value();
    }

    public void bytesReceivedAdd(long bytes) {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.bytesReceived.add(bytes);
        }
    }

    public long streamerBatchesSent() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.streamerBatchesSent.value();
    }

    @Override
    public void streamerBatchesSentAdd(long batches) {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.streamerBatchesSent.add(batches);
        }
    }

    public long streamerItemsSent() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.streamerItemsSent.value();
    }

    @Override
    public void streamerItemsSentAdd(long items) {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.streamerItemsSent.add(items);
        }
    }

    public long streamerBatchesActive() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.streamerBatchesActive.value();
    }

    @Override
    public void streamerBatchesActiveAdd(long batches) {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.streamerBatchesActive.add(batches);
        }
    }

    public long streamerItemsQueued() {
        Holder h2 = (Holder)this.holder();
        return h2 == null ? 0L : h2.streamerItemsQueued.value();
    }

    @Override
    public void streamerItemsQueuedAdd(long items) {
        Holder h2 = (Holder)this.holder();
        if (h2 != null) {
            h2.streamerItemsQueued.add(items);
        }
    }

    @Override
    protected Holder createHolder() {
        return new Holder();
    }

    protected static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final AtomicLongMetric connectionsActive = new AtomicLongMetric("ConnectionsActive", "Currently active connections");
        private final AtomicLongMetric connectionsEstablished = new AtomicLongMetric("ConnectionsEstablished", "Total established connections");
        private final AtomicLongMetric connectionsLost = new AtomicLongMetric("ConnectionsLost", "Total lost connections");
        private final AtomicLongMetric connectionsLostTimeout = new AtomicLongMetric("ConnectionsLostTimeout", "Total lost connections due to a timeout");
        private final AtomicLongMetric handshakesFailed = new AtomicLongMetric("HandshakesFailed", "Total failed handshakes");
        private final AtomicLongMetric handshakesFailedTimeout = new AtomicLongMetric("HandshakesFailedTimeout", "Total failed handshakes due to a timeout");
        private final AtomicLongMetric requestsActive = new AtomicLongMetric("RequestsActive", "Currently active requests");
        private final AtomicLongMetric requestsSent = new AtomicLongMetric("RequestsSent", "Total requests sent");
        private final AtomicLongMetric requestsCompleted = new AtomicLongMetric("RequestsCompleted", "Total requests completed (response received)");
        private final AtomicLongMetric requestsRetried = new AtomicLongMetric("RequestsRetried", "Total requests retries (request sent again after a failure)");
        private final AtomicLongMetric requestsFailed = new AtomicLongMetric("RequestsFailed", "Total requests failed");
        private final AtomicLongMetric bytesSent = new AtomicLongMetric("BytesSent", "Total bytes sent");
        private final AtomicLongMetric bytesReceived = new AtomicLongMetric("BytesReceived", "Total bytes received");
        private final AtomicLongMetric streamerBatchesSent = new AtomicLongMetric("StreamerBatchesSent", "Total data streamer batches sent");
        private final AtomicLongMetric streamerItemsSent = new AtomicLongMetric("StreamerItemsSent", "Total number of data streamer items sent");
        private final AtomicLongMetric streamerBatchesActive = new AtomicLongMetric("StreamerBatchesActive", "Total number of existing data streamer batches");
        private final AtomicLongMetric streamerItemsQueued = new AtomicLongMetric("StreamerItemsQueued", "Total number of queued data streamer items (rows)");
        final List<Metric> metrics = List.of(this.connectionsActive, this.connectionsEstablished, this.connectionsLost, this.connectionsLostTimeout, this.handshakesFailed, this.handshakesFailedTimeout, this.requestsActive, this.requestsSent, this.requestsCompleted, this.requestsRetried, this.requestsFailed, this.bytesSent, this.bytesReceived, this.streamerBatchesSent, this.streamerItemsSent, this.streamerBatchesActive, this.streamerItemsQueued);

        protected Holder() {
        }

        @Override
        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

