/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.ui.widgets.ConnectionActionGroup;
import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ConnectionUniversalListener;
import org.apache.directory.studio.connection.ui.widgets.ConnectionWidget;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectBrowserConnectionDialog
extends Dialog {
    private String title;
    private IBrowserConnection initialBrowserConnection;
    private IBrowserConnection selectedBrowserConnection;
    private ConnectionConfiguration connectionConfiguration;
    private ConnectionUniversalListener connectionUniversalListener;
    private ConnectionActionGroup connectionActionGroup;
    private ConnectionWidget connectionMainWidget;

    public SelectBrowserConnectionDialog(Shell parentShell, String title, IBrowserConnection initialBrowserConnection) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.title = title;
        this.initialBrowserConnection = initialBrowserConnection;
        this.selectedBrowserConnection = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public boolean close() {
        if (this.connectionMainWidget != null) {
            this.connectionConfiguration.dispose();
            this.connectionConfiguration = null;
            this.connectionActionGroup.deactivateGlobalActionHandlers();
            this.connectionActionGroup.dispose();
            this.connectionActionGroup = null;
            this.connectionUniversalListener.dispose();
            this.connectionUniversalListener = null;
            this.connectionMainWidget.dispose();
            this.connectionMainWidget = null;
        }
        return super.close();
    }

    protected void okPressed() {
        this.selectedBrowserConnection = this.initialBrowserConnection;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selectedBrowserConnection = null;
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Connection connection;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        composite.setLayoutData((Object)gd);
        this.connectionConfiguration = new ConnectionConfiguration();
        this.connectionMainWidget = new ConnectionWidget(this.connectionConfiguration, null);
        this.connectionMainWidget.createWidget(composite);
        this.connectionMainWidget.setInput((Object)ConnectionCorePlugin.getDefault().getConnectionFolderManager());
        this.connectionActionGroup = new ConnectionActionGroup(this.connectionMainWidget, this.connectionConfiguration);
        this.connectionActionGroup.fillToolBar(this.connectionMainWidget.getToolBarManager());
        this.connectionActionGroup.fillMenu(this.connectionMainWidget.getMenuManager());
        this.connectionActionGroup.fillContextMenu(this.connectionMainWidget.getContextMenuManager());
        this.connectionActionGroup.activateGlobalActionHandlers();
        this.connectionUniversalListener = new ConnectionUniversalListener(this.connectionMainWidget.getViewer());
        this.connectionMainWidget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                if (!event.getSelection().isEmpty() && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Connection) {
                    Connection connection = (Connection)o;
                    IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
                    SelectBrowserConnectionDialog.this.initialBrowserConnection = browserConnection;
                }
            }
        });
        this.connectionMainWidget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                if (!event.getSelection().isEmpty() && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Connection) {
                    Connection connection = (Connection)o;
                    IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
                    SelectBrowserConnectionDialog.this.initialBrowserConnection = browserConnection;
                    SelectBrowserConnectionDialog.this.okPressed();
                }
            }
        });
        if (this.initialBrowserConnection != null && (connection = this.initialBrowserConnection.getConnection()) != null) {
            this.connectionMainWidget.getViewer().reveal((Object)connection);
            this.connectionMainWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)connection), true);
        }
        SelectBrowserConnectionDialog.applyDialogFont((Control)composite);
        this.connectionMainWidget.setFocus();
        return composite;
    }

    public IBrowserConnection getSelectedBrowserConnection() {
        return this.selectedBrowserConnection;
    }
}

