/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpecificLeafTest {
    @Test
    public void checkByteBufferLeaves() {
        int bytes = 128;
        ByteBuffer bb = ByteBuffer.allocate(bytes);
        bb.order(ByteOrder.nativeOrder());
        Memory mem = Memory.wrap((ByteBuffer)bb).region(0L, (long)bytes, ByteOrder.nativeOrder());
        ResourceImpl bsi = (ResourceImpl)mem;
        int typeId = bsi.getTypeId();
        Assert.assertTrue((boolean)bsi.hasByteBuffer());
        Assert.assertTrue((boolean)ResourceImpl.isNativeOrder((int)typeId));
        Assert.assertTrue((boolean)mem.isReadOnly());
        SpecificLeafTest.checkCrossLeafTypeIds(mem);
        Buffer buf = mem.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
        bb.order(Util.NON_NATIVE_BYTE_ORDER);
        Memory mem2 = Memory.wrap((ByteBuffer)bb).region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf2 = mem2.asBuffer().region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf3 = buf2.duplicate();
        Assert.assertTrue((boolean)((ResourceImpl)mem).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)mem2).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)buf).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)buf2).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)buf3).isDuplicate());
    }

    @Test
    public void checkDirectLeaves() {
        int bytes = 128;
        try (WritableMemory wmem = WritableMemory.allocateDirect((long)bytes);){
            Assert.assertTrue((boolean)((ResourceImpl)wmem).isDirect());
            Assert.assertFalse((boolean)wmem.isReadOnly());
            SpecificLeafTest.checkCrossLeafTypeIds((Memory)wmem);
            WritableMemory nnwmem = wmem.writableRegion(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
            Memory mem = wmem.region(0L, (long)bytes, ByteOrder.nativeOrder());
            Buffer buf = mem.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
            Memory mem2 = nnwmem.region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf2 = mem2.asBuffer().region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf3 = buf2.duplicate();
            Assert.assertTrue((boolean)((ResourceImpl)mem).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)mem2).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)buf).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)buf2).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)buf3).isDuplicate());
        }
    }

    @Test
    public void checkHeapLeaves() {
        int bytes = 128;
        Memory mem = Memory.wrap((byte[])new byte[bytes]);
        ResourceImpl bsi = (ResourceImpl)mem;
        Assert.assertTrue((boolean)bsi.isHeap());
        Assert.assertTrue((boolean)bsi.isReadOnly());
        SpecificLeafTest.checkCrossLeafTypeIds(mem);
        Memory nnreg = mem.region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Memory reg = mem.region(0L, (long)bytes, ByteOrder.nativeOrder());
        Buffer buf = reg.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
        Buffer buf4 = buf.duplicate();
        Memory reg2 = nnreg.region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf2 = reg2.asBuffer().region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf3 = buf2.duplicate();
        Assert.assertFalse((boolean)((ResourceImpl)mem).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)reg2).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)buf).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)buf2).isRegionView());
        Assert.assertTrue((boolean)((ResourceImpl)buf3).isDuplicate());
        Assert.assertTrue((boolean)((ResourceImpl)buf4).isDuplicate());
    }

    @Test
    public void checkMapLeaves() throws IOException {
        File file = new File("TestFile2.bin");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        long bytes = 128L;
        try (WritableMemory mem = WritableMemory.writableMap((File)file, (long)0L, (long)128L, (ByteOrder)ByteOrder.nativeOrder());){
            Assert.assertTrue((boolean)((ResourceImpl)mem).isMapped());
            Assert.assertFalse((boolean)mem.isReadOnly());
            SpecificLeafTest.checkCrossLeafTypeIds((Memory)mem);
            Memory nnreg = mem.region(0L, 128L, Util.NON_NATIVE_BYTE_ORDER);
            Memory reg = mem.region(0L, 128L, ByteOrder.nativeOrder());
            Buffer buf = reg.asBuffer().region(0L, 128L, ByteOrder.nativeOrder());
            Buffer buf4 = buf.duplicate();
            Memory reg2 = nnreg.region(0L, 128L, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf2 = reg2.asBuffer().region(0L, 128L, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf3 = buf2.duplicate();
            Assert.assertTrue((boolean)((ResourceImpl)reg).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)reg2).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)buf).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)buf2).isRegionView());
            Assert.assertTrue((boolean)((ResourceImpl)buf3).isDuplicate());
            Assert.assertTrue((boolean)((ResourceImpl)buf4).isDuplicate());
        }
    }

    private static void checkCrossLeafTypeIds(Memory mem) {
        Memory reg1 = mem.region(0L, mem.getCapacity());
        Assert.assertTrue((boolean)((ResourceImpl)reg1).isRegionView());
        Buffer buf1 = reg1.asBuffer();
        Assert.assertTrue((boolean)((ResourceImpl)buf1).isRegionView());
        ResourceImpl cfr_ignored_0 = (ResourceImpl)buf1;
        Assert.assertTrue((boolean)ResourceImpl.isBuffer((int)((ResourceImpl)buf1).getTypeId()));
        Assert.assertTrue((boolean)buf1.isReadOnly());
        Buffer buf2 = buf1.duplicate();
        Assert.assertTrue((boolean)((ResourceImpl)buf2).isRegionView());
        ResourceImpl cfr_ignored_1 = (ResourceImpl)buf2;
        Assert.assertTrue((boolean)ResourceImpl.isBuffer((int)((ResourceImpl)buf2).getTypeId()));
        Assert.assertTrue((boolean)((ResourceImpl)buf2).isDuplicate());
        Assert.assertTrue((boolean)buf2.isReadOnly());
        Memory mem2 = buf1.asMemory();
        Assert.assertTrue((boolean)((ResourceImpl)mem2).isRegionView());
        ResourceImpl cfr_ignored_2 = (ResourceImpl)mem2;
        Assert.assertFalse((boolean)ResourceImpl.isBuffer((int)((ResourceImpl)mem2).getTypeId()));
        Assert.assertFalse((boolean)((ResourceImpl)mem2).isDuplicate());
        Assert.assertTrue((boolean)mem2.isReadOnly());
        Buffer buf3 = buf1.duplicate(Util.NON_NATIVE_BYTE_ORDER);
        Assert.assertTrue((boolean)((ResourceImpl)buf3).isRegionView());
        ResourceImpl cfr_ignored_3 = (ResourceImpl)buf3;
        Assert.assertTrue((boolean)ResourceImpl.isBuffer((int)((ResourceImpl)buf3).getTypeId()));
        Assert.assertTrue((boolean)((ResourceImpl)buf3).isDuplicate());
        Assert.assertTrue((boolean)((ResourceImpl)buf3).isNonNativeOrder());
        Assert.assertTrue((boolean)buf3.isReadOnly());
        Memory mem3 = buf3.asMemory();
        Assert.assertTrue((boolean)((ResourceImpl)mem3).isRegionView());
        ResourceImpl cfr_ignored_4 = (ResourceImpl)mem3;
        Assert.assertFalse((boolean)ResourceImpl.isBuffer((int)((ResourceImpl)mem3).getTypeId()));
        Assert.assertTrue((boolean)((ResourceImpl)mem3).isDuplicate());
        Assert.assertTrue((boolean)((ResourceImpl)mem3).isNonNativeOrder());
        Assert.assertTrue((boolean)mem3.isReadOnly());
    }
}

